#ifndef ACTUATOR_IMPLEMENTATION_BASE_H
#define ACTUATOR_IMPLEMENTATION_BASE_H

// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "Actuator.h"

/** The ActuatorImplementationBase implementation base class.

    The ActuatorImplementationBase class represents an implementation
    of the abstract Actuator abstract class. User instantiates this
    class.
    
*/
template <class ElementType>
class ActuatorImplementationBase : public Actuator {
public:

   /**@name Public Class Methods of ActuatorImplementationBase */
   //@{

   /// Constructor
   ActuatorImplementationBase(){};

   ~ActuatorImplementationBase(){};
   

   /// Actuate or set the new value of the control element
   void setValue( ElementType &newValue ){
      actuatorElement = newValue;
   }

   //@} // End of Public Class Methods of ActuatorImplementationBase

private:
   
   /**@name Private Class Attributes of ActuatorImplementationBase */
   //@{

   string actuatorName;
   ElementType actuatorElement;
   

   //@} // End of Private Class Attributes of ActuatorImplementationBase
   

};

#endif


