--  2001, 2002 Peter Thiemann
module Main where

import Char
import Prelude hiding (head, span, map)
import CGI hiding (div)

main = 
  run mainCGI

mainCGI = 
  calc "0" id

calc dstr f =
  ask $ standardPage "Calculator" $ makeForm $ table $
  do dsp <- tr_T (td_S (textInputField (fieldVALUE dstr) ## attr_SS "colspan" "4"))
     let button c = td_T (submit dsp (calcAction c f) (fieldVALUE [c]))
     tr_T (button '1' ## button '2' ## button '3' ## button '+')
     tr_T (button '4' ## button '5' ## button '6' ## button '-')
     tr_T (button '7' ## button '8' ## button '9' ## button '*')
     tr_T (button 'C' ## button '0' ## button '=' ## button '/')

calcAction c f dsp
  | isDigit c = calc (dstr ++ [c]) f
  | c == 'C'  = mainCGI
  | c == '='  = calc (show (f (read dstr :: Integer))) id
  | otherwise = calc "0" (optable c (read dstr :: Integer))
  where dstr = value dsp
	optable '+' = (+)
	optable '-' = (-)
	optable '*' = (*)
	optable '/' = div
  
  
