module RepBase (module Item, module RepBase) where

import Auxiliary
import Char
import Directory
import List hiding (head)
import Maybe
import Random
import Prelude hiding (head)
import HTMLMonad
import CGI
import Item
import System
import Locking
import Email

--------------------------------------------------------------------------------


newReviewer name pcname password = do
 obtainLock reviewerFile
 s <- readFileNonExistent reviewerFile ""
 let l = fmap read $ lines s
 addReviewer name pcname password l


addReviewer name pcname password rs = do
 g <- getStdGen
 let rid = take 8 $ randomRs ('a','z') g
 if elem rid (fmap reviewerID rs) 
  then addReviewer name pcname password rs 
  else do
   appendFile reviewerFile (show (Reviewer rid name pcname password) ++ "\n")
   releaseLock reviewerFile
   return rid
    
data Reviewer = Reviewer { reviewerID :: String
                         , reviewerName :: String
                         , reviewerPCMember :: String
                         , reviewerPassword :: String
                         }
 deriving (Read,Show)

getReviewerData rid = do
 obtainLock reviewerFile
 s <- readFileNonExistent reviewerFile ""
 releaseLock reviewerFile
 let l = fmap read $ lines s
 return $  listToMaybe [a | a <- l, reviewerID a == rid]

selector txt lo hi =
  do td (text txt)
     td (selectSingle show Nothing [lo..hi] empty)

ratings1 = table $ tr $ do
    relevanceF   <- selector "Relevance" 0 4
    originalityF <- selector "Originality" 0 4
    clarityF     <- selector "Clarity" 0 4
    soundnessF   <- selector "Soundness" 0 4
    confidenceF  <- selector "Confidence" 0 4
    return (relevanceF, originalityF, clarityF, soundnessF, confidenceF)



writeReport pcname reviewername submission reference F0 =
 venueQuery "Submit Review" $ do
  formatSubmissionStandard submission
  p_T reference
  p_T $ text ("PC Member: " ++ pcname)
  p_T $ text ("Reviewer: " ++ reviewername)
  (relevanceF, originalityF, clarityF, soundnessF, confidenceF) <- p_T ratings1 
  p_T (text_S "4 = very good/high, 3 = good, 2 = average, 1 = weak, 0 = very weak/low")
  ratingF <- p_T $ table_S (tr_S (selector "Overall Rating" 0 4 ##
                            td_S (text_S "4 = must accept, 3 = acceptable, 2 = marginal, 1 = reject, 0 = out of scope")))
  forAuthorF <- p_T $ do
    text_S "Comments for Author" >> br_S empty
    makeTextarea "" (attr_SS "rows" "20" ## attr_SS "cols" "75") ## 
		    attr_SS "colspan" "2"
  forPCF <- p_T $ do
   text_S "Comments for PC" >> br_S empty
   makeTextarea "" (attr_SS "rows" "3" ## attr_SS "cols" "75") ## attr_SS "colspan" "2"
  let password = itemPassword submission
      fields = F8 forAuthorF forPCF ratingF 
      		  relevanceF originalityF clarityF soundnessF confidenceF
      call = sendReport password reviewername pcname
  p_T $ submit fields call (fieldVALUE "Send report")


sendReport password reviewername pcname 
           (F8 forAuthorF forPCF ratingF 
	       relevanceF originalityF clarityF soundnessF confidenceF) = 
  do io (do addReport 
	         password 
		 reviewername 
		 pcname 
		 (value forAuthorF) 
		 (value forPCF)
		 (value ratingF)
		 (value relevanceF)
		 (value originalityF)
		 (value clarityF)
		 (value soundnessF)
		 (value confidenceF)
	    let message = simpleMail [pcname] (venueName ++ ": Review Received")
		     (textDOC "plain" 
		     ["Your reviewer " ++ reviewername ++ " entered a review."])
	    sendmail message)
     venueQuery "Review Received" $ text "Your report is saved. Thank you."

formatSubmissionStandard submission =
 table_T ((tr_S ((td_S (b_S $ text_S "Author"))      ## (td_S (text (itemAuthor      submission)))))
     ## (tr_S ((td_S (b_S $ text_S "Title"))       ## (td_S (text (itemTitle       submission)))))
     ## (tr_S ((td_S (b_S $ text_S "Affiliation")) ## (td_S (text (itemAffiliation submission)))))
     ## (tr_S ((td_S (b_S $ text_S "Email"))       ## (td_S (text (itemEmail       submission)))))
     ## (tr_S ((td_S (b_S $ text_S "Number"))      ## (td_S (text (show $ itemNumber submission)))))
       )
