module Main where

import IO
import Monad
import System

data FIELDTYPES = 
    STRING | BOOL Bool | STRING_LIST

fieldDesc = [("name", STRING)
	    ,("auto", BOOL False)
	    ,("import_dirs", STRING_LIST)
	    ,("source_dirs", STRING_LIST)
	    ,("library_dirs", STRING_LIST)
	    ,("hs_libraries", STRING_LIST)
	    ,("extra_libraries", STRING_LIST)
	    ,("include_dirs", STRING_LIST)
	    ,("c_includes", STRING_LIST)
	    ,("package_deps", STRING_LIST)
	    ,("extra_ghc_opts", STRING_LIST)
	    ,("extra_ld_opts", STRING_LIST)
	    ,("framework_dirs", STRING_LIST)
	    ,("extra_frameworks", STRING_LIST)]

main =
  do args <- getArgs
     let pkg = parseArgs "name" fieldDesc args
     package pkg

package pkg =
  do putStrLn "Package{"
     commaSeparated (putField pkg) fieldDesc
     putStrLn "}"

commaSeparated f [] = return ()
commaSeparated f [x] = f x
commaSeparated f (x:xs) = do { f x; putStrLn ","; commaSeparated f xs }

putField pkg (fname, ftype) =
  let vals = assocList pkg fname in
  do putStr fname
     putStr " = "
     case ftype of 
       STRING ->
	 case vals of
	   [val] ->
	     putStr (show val) 
	   _ -> 
	     error ("Field " ++ fname ++ " must be defined exactly once")
       BOOL b ->
	 case vals of
	   [] ->
	     putStr (show b)
	   _ -> 
	     let val = last vals in
	     case reads val of
	       ((x, ""):_) | x || not x -> putStr val
	       _ -> error ("Field " ++ fname ++ " must be a Bool")
       STRING_LIST ->
	 putStr (show vals)

parseArgs lname desc [] =
  []
parseArgs lname desc (('-':'-':flag) : rest) =
  case lookup flag desc of
    Nothing ->
      error ("Unknown field name: " ++ flag)
    Just _ ->
      parseArgs flag desc rest
parseArgs lname desc (word : rest) =
  (lname, word) : parseArgs lname desc rest
	   
     
assocList :: Eq x => [(x, y)] -> x -> [y]
assocList []     x = []
assocList ((y,y'):ys) x = let zs = assocList ys x in if x == y then y' : zs else zs
