--  2001, 2002 Peter Thiemann
-- |Types of outputable data.
module CGITypes where

import HTMLWrapper (WithHTML)

newtype URL = URL { unURL :: String }

data FileReference =
     FileReference { fileReferenceName :: FilePath
     		   -- ^ valid local filename where this file can be accessed
     		   , fileReferenceContentType :: String
		   , fileReferenceExternalName :: String
		   }
     deriving (Show, Read)

-- |Assumes that file contains correctly formatted HTTP Response starting with
-- Content-Type. Used internally to implement frames.
data ResponseFileReference =
     ResponseFileReference FilePath

data Status = Status { statusCode :: Int		    -- ^ status code
		     , statusReason :: String		    -- ^ reason phrase
		     , statusContent :: Maybe (WithHTML () IO ())   -- ^ more explanation
		     }

newtype Location = Location URL				    -- ^ redirection

data FreeForm =
     FreeForm	{ ffName :: String			    -- ^ internal name
		, ffContentType :: String		    -- ^ MIME type
		, ffRawContents :: String		    -- ^ contents as octet stream
		}

data CGIOption
  = NoPort	-- ^ do not include port number in generated URLs
  | AutoPort	-- ^ include automatically generated port number in generated URLs
  | Port Int	-- ^ use this port number in generated URLs
  | NoHttps     -- ^ do not attempt to detect Https
  | AutoHttps   -- ^ autodetect Https by checking for port number 443 and env var HTTPS
  | FullURL     -- ^ generate full URL including scheme, host, and port
  | PartialURL  -- ^ generate absolute path URL, only
  deriving Eq
type CGIOptions = [CGIOption]

