let gWeaveCommon = {
  // opens in a new window if we're in a modal prefwindow world, in a new tab otherwise
  _openLink: function (url) {
    if (document.documentElement.id == "accountSetup" &&
        window.opener &&
        window.opener.document.documentElement.id == "BrowserPreferences" &&
        !window.opener.document.documentElement.instantApply)
      openUILinkIn(url, "window");
    else if (document.documentElement.id == "BrowserPreferences" &&
             !document.documentElement.instantApply)
      openUILinkIn(url, "window");
    else
      openUILinkIn(url, "tab");
  },

  changeName: function changeName(input) {
    // Make sure to update to a modified name, e.g., empty-string -> default
    Weave.Clients.localName = input.value;
    input.value = Weave.Clients.localName;
  },

  openChange: function openChange(type) {
    // Just re-show the dialog if it's already open
    let openedDialog = Weave.Svc.WinMediator.getMostRecentWindow("Sync:" + type);
    if (openedDialog != null) {
      openedDialog.focus();
      return;
    }

    // Open up the change dialog
    let changeXUL = "chrome://weave/content/firefox/generic-change.xul";
    let changeOpt = "centerscreen,chrome,dialog,modal,resizable=no";
    Weave.Svc.WinWatcher.activeWindow.openDialog(changeXUL, "", changeOpt, type);
  },

  changePassword: function () {
    gWeaveCommon.openChange("ChangePassword");
  },

  resetPassphrase: function () {
    gWeaveCommon.openChange("ResetPassphrase");
  },

  updatePassphrase: function () {
    gWeaveCommon.openChange("UpdatePassphrase");
  },

  resetPassword: function () {
    this._openLink(Weave.Service.pwResetURL);
  },

  openToS: function () {
    this._openLink(Weave.Svc.Prefs.get("termsURL"));
  },

  openPP: function () {
    this._openLink(Weave.Svc.Prefs.get("privacyURL"));
  },

  // xxxmpc - fix domain before 1.3 final
  _baseURL: "http://www.mozilla.com/firefox/sync/",

  openFirstClientFirstrun: function () {
    let url = this._baseURL + "firstrun.html";
    this._openLink(url);
  },

  openAddedClientFirstrun: function () {
    let url = this._baseURL + "secondrun.html";
    this._openLink(url);
  },

  /**
   * validatePassword / validatePassphrase
   *
   * @param el1 : the first textbox element in the form
   * @param el2 : the second textbox element, if omitted it's an update form
   * 
   * returns [valid, errorString]
   */

  validatePassword: function (el1, el2) {
    return this._validate(el1, el2, true);
  },

  validatePassphrase: function (el1, el2) {
    return this._validate(el1, el2, false);
  },

  _validate: function (el1, el2, isPassword) {
    let valid = false;
    let val1 = el1.value;
    let val2 = el2 ? el2.value : "";
    let error = "";

    if (isPassword) {
      if (!el2)
        valid = val1.length >= Weave.MIN_PASS_LENGTH;
      else if (val1 && val1 == Weave.Service.username)
        error = "change.password.pwSameAsUsername";
      else if (val1 && val1 == Weave.Service.password)
        error = "change.password.pwSameAsPassword";
      else if (val1 && val1 == Weave.Service.passphrase)
        error = "change.password.pwSameAsPassphrase";
      else if (val1 && val2) {
        if (val1 == val2 && val1.length >= Weave.MIN_PASS_LENGTH)
          valid = true;
        else if (val1.length < Weave.MIN_PASS_LENGTH)
          error = "change.password.tooShort";
        else if (val1 != val2)
          error = "change.password.mismatch";
      }
    }
    else {
      if (!el2)
        valid = val1.length >= Weave.MIN_PP_LENGTH;
      else if (val1 == Weave.Service.username)
        error = "change.passphrase.ppSameAsUsername";
      else if (val1 == Weave.Service.password)
        error = "change.passphrase.ppSameAsPassword";
      else if (val1 == Weave.Service.passphrase)
        error = "change.passphrase.ppSameAsPassphrase";
      else if (val1 && val2) {
        if (val1 == val2 && val1.length >= Weave.MIN_PP_LENGTH)
          valid = true;
        else if (val1.length < Weave.MIN_PP_LENGTH)
          error = "change.passphrase.tooShort";
        else if (val1 != val2)
          error = "change.passphrase.mismatch";
      }
    }
    let errorString = error ? Weave.Utils.getErrorString(error) : "";
    dump("valid: " + valid + " error: " + errorString + "\n");
    return [valid, errorString];
  }
}

