#!/usr/bin/perl
#
# Test WebAuth Perl bindings and WebLogin for strict, warnings, and syntax.
#
# Copyright 2012, 2013
#     The Board of Trustees of the Leland Stanford Junior University
#
# See LICENSE for licensing terms.

use strict;
use warnings;

use File::Spec;
use Test::More;

# Skip tests if Test::Strict is not installed.
eval { require Test::Strict };
if ($@) {
    plan skip_all => 'Test::Strict required to test Perl syntax';

    # Suppress "only used once" warnings.
    $Test::Strict::TEST_SKIP           = [];
    $Test::Strict::TEST_WARNINGS       = 0;
}
Test::Strict->import;

# Test everything in the perl directory except the Build script generated by
# Module::Build..  We also want to check use warnings.
$Test::Strict::TEST_SKIP = ['Build'];
$Test::Strict::TEST_WARNINGS = 1;
all_perl_files_ok(File::Spec->curdir);
