#!/usr/bin/env python

from distutils.core import setup
import glob, os, commands, sys

data_files = []
if sys.argv[1] == 'install':
    if not os.path.isdir('build'):
        os.makedirs('build')
    os.system("intltool-merge -d po servers/GNOME_WebBoardApplet.server.in build/GNOME_WebBoardApplet.server")
    os.system("intltool-merge -d po data/webboard.schemas.in build/webboard.schemas")
    data_files += [('lib/bonobo/servers', ['build/GNOME_WebBoardApplet.server'])]
    data_files += [('../etc/gconf/schemas', ['build/webboard.schemas'])]
    os.system('intltool-merge -d po data/webboard.desktop.in build/webboard.desktop')
    data_files += [('share/applications', ['build/webboard.desktop'])]
    for name in os.listdir(os.path.join(os.path.realpath('.'), 'po')):
        if name[-2:] == 'po':
            if not os.path.isdir('build/locale/' + name[:-3]):
                os.makedirs('build/locale/' + name[:-3])
                os.system('msgfmt -o build/locale/' + name[:-3] + \
                          '/webboard.mo po/' + name[:-3] + '.po')
                data_files.append(('share/locale/' + name[:-3] + \
                                   '/LC_MESSAGES',['build/locale/' + \
                                   name[:-3] + '/webboard.mo']))

setup(
    name = 'webboard',
    version = '0.2.1',
    description = 'Simple fd.o Compliant Menu Editor',
    author = 'Sebastian Heinlein',
    author_email = 'sebastian.heinlein@web.de',
    url = 'http://www.pimpzkru.de/sebi/blog',
    packages = ['webboard'],
    package_dir = {'webboard': 'src'},
    scripts = ['src/webboard', 'src/webboard-applet'],
    data_files = data_files + [('share/webboard', ['data/webboard.glade', \
                 'data/wbconfig.glade']),
    ('share/pixmaps', ['data/gtk-paste.png'])],
    license = 'GNU LGPL',
    platforms = 'posix',
)

if sys.argv[1] == 'clean':
    for root, dirs, files in os.walk('build', topdown=False):
        for name in files:
            os.remove(os.path.join(root, name))
        for name in dirs:
            os.rmdir(os.path.join(root, name))
    if os.path.isdir('build'):
        os.rmdir('build')
