
# about.py - plugin to list some information about used plugins
#
# Copyright (C) 1998, 1999 Albert Hopkins (marduk)
# Copyright (C) 2002 Mike W. Meyer
# Copyright (C) 2005 Arthur de Jong
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#
# The files produced as output from the software do not automatically fall
# under the copyright of the software, unless explicitly stated otherwise.

"""Present an overview of the plugins that are used."""

__title__ = 'about webcheck'
__author__ = 'Arthur de Jong'

import config
import plugins
import time

def generate(fp,site):
    """Output a list of modules, it's authors and it's version to the file descriptor."""
    # TODO: xxx links weere fetched, xxx pages were examined and a total of xxx notes and problems were found
    # TODO: include some runtime information (e.g. supported schemes, user configuration, etc)
    # output some general information about the report
    fp.write(
      '   <p>\n'
      '    This is a website report generated by <tt>webcheck</tt> %(version)s.\n'
      '    <tt>webcheck</tt> is a website checking tool for webmasters. It\n'
      '    crawls a given website and does a number of tests to see if links\n'
      '    and pages are valid.\n'
      '    More information about <tt>webcheck</tt> can be found at the\n'
      '    <tt>webcheck</tt> homepage which is located at\n'
      '    <a href="%(homepage)s">%(homepage)s</a>.\n'
      '   </p>\n'
      '   <p>\n'
      '    This report was generated on %(time)s, a total of %(numurls)d links were found.\n'
      '   </p>\n\n'
      % { 'version':  plugins.escape(config.VERSION),
          'time':     plugins.escape(time.ctime(time.time())),
          'numurls':  len(site.linkMap),
          'homepage': config.HOMEPAGE } )
    # output copyright information
    fp.write(
      '   <h3>Copyright</h3>\n'
      '   <p>\n'
      '    <tt>webcheck</tt> was originally named <tt>linbot</tt> which was developed\n'
      '    by Albert Hopkins (marduk).\n'
      '    Versions up till 1.0 were maintained by Mike W. Meyer who changed the name\n'
      '    to <tt>webcheck</tt>.\n'
      '    After that Arthur de Jong did a complete rewrite.\n'
      '    <tt>webcheck</tt> is <i>free software</i>; you can redistribute it and/or\n'
      '    modify it under the terms of the\n'
      '    <a href="http://www.gnu.org/copyleft/gpl.html">GNU General Public License</a>.\n'
      '    There is no warranty; not even for merchantability or fitness for a\n'
      '    particular purpose. See the source for further details.\n'
      '   </p>\n'
      '   <p>\n'
      '    Copyright &copy; 1998, 1999, 2002, 2005 Albert Hopkins (marduk),\n'
      '    Mike W. Meyer and Arthur de Jong\n'
      '   </p>\n'
      '   <p>\n'
      '    The files in this generated report do not automatically fall under\n'
      '    the copyright of the software, unless explicitly stated otherwise.\n'
      '   </p>\n'
      '   <p>\n'
      '    <tt>webcheck</tt> includes the\n'
      '    <a href="http://www.victr.lm85.com/projects/fancytooltips/">FancyTooltips</a>\n'
      '    javascript library to display readable tooltips. FancyTooltips is distributed\n'
      '    under the MIT license and has the following copyright notices (see\n'
      '    <tt>fancytooltips.js</tt> for details):\n'
      '   </p>\n'
      '   <p>\n'
      '    Copyright &copy; 2003, 2005 Stuart Langridge, Paul McLanahan,\n'
      '    Peter Janes, Brad Choate, Dunstan Orchard, Ethan Marcotte,\n'
      '    Mark Wubben and Victor Kulinski\n'
      '   </p>\n\n' )
    # output plugin information
    fp.write(
      '   <h3>Plugins</h3>\n'
      '   <ul>\n')
    for plugin in config.PLUGINS:
        report = __import__('plugins.'+plugin,globals(),locals(),[plugin])
        fp.write(
          '    <li>\n'
          '     <strong>%s</strong><br />\n'
          % plugins.escape(report.__title__) )
        if hasattr(report,"__doc__"):
            fp.write('     %s<br />\n' % plugins.escape(report.__doc__))
        fp.write('    </li>\n')
    fp.write(
      '   </ul>\n' )
