// Adds an href to the history
function webdeveloper_addToHistory(href)
{
    // If the href is set
    if(href)
    {
        var globalHistory = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIGlobalHistory);

        // If the href is not already in the history
        if(!globalHistory.isVisited(href))
        {
            globalHistory.addPage(href);
        }
    }
}

// Clears the history
function webdeveloper_removeAllFromHistory()
{
    Components.classes["@mozilla.org/browser/global-history;2"].getService(Components.interfaces.nsIBrowserHistory).removeAllPages();
}

// Removes an href from the history
function webdeveloper_removeFromHistory(href)
{
    // If the href is set
    if(href)
    {
        var globalHistory = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIGlobalHistory);

        // If the href is in the history
        if(globalHistory.isVisited(href))
        {
            Components.classes["@mozilla.org/browser/global-history;2"].getService(Components.interfaces.nsIBrowserHistory).removePage(Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(href, null, null));
        }
    }
}
