/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "datetimehelper.h"

using namespace WebIssues;

QString DateTimeHelper::formatDate( const QDate& date )
{
    return date.toString( "yyyy-MM-dd" );
}

QString DateTimeHelper::formatDateTime( const QDateTime& dateTime )
{
    return dateTime.toString( "yyyy-MM-dd hh:mm" );
}

QDate DateTimeHelper::parseDate( const QString& text )
{
    if ( text.length() == 10 ) {
        QDate date = QDate::fromString( text, Qt::ISODate );
        if ( date.isValid() )
            return date;
    } else if ( text.length() == 16 ) {
        QDateTime dateTime = QDateTime::fromString( text, Qt::ISODate );
        if ( dateTime.isValid() )
            return dateTime.date();
    }
    return QDate();
}

QDateTime DateTimeHelper::parseDateTime( const QString& text )
{
    if ( text.length() == 16 ) {
        QDateTime dateTime = QDateTime::fromString( text, Qt::ISODate );
        if ( dateTime.isValid() )
            return dateTime;
    } else if ( text.length() == 10 ) {
        QDate date = QDate::fromString( text, Qt::ISODate );
        if ( date.isValid() )
            return QDateTime( date, QTime( 0, 0 ) );
    }
    return QDateTime();
}

int DateTimeHelper::compareDateTime( const QDateTime& dateTime1, const QDateTime& dateTime2 )
{
    if ( dateTime1 < dateTime2 )
        return -1;
    if ( dateTime1 > dateTime2 )
        return 1;
    return 0;
}
