/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef COLUMNSETTINGSDIALOG_H
#define COLUMNSETTINGSDIALOG_H

#include <QDialog>

#include "models/abstracttablemodel.h"

class QLabel;
class QToolButton;
class QListWidget;
class QDialogButtonBox;

namespace WebIssues
{

/**
* Dialog for modifying column settings for a list.
*/
class ColumnSettingsDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    ColumnSettingsDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~ColumnSettingsDialog();

public:
    /**
    * Set the prompt text.
    */
    void setPrompt( const QString& text );

    /**
    * Set a list of all available columns.
    */
    void setAvailableColumns( const QList<Column>& columns );

    /**
    * Set the default list of columns.
    */
    void setDefaultColumns( const QList<Column>& columns );

    /**
    * Set the number of fixed columns in the list.
    *
    * Fixed columns cannot be removed or repositioned.
    */
    void setFixedColumns( int count );

    /**
    * Initialize the dialog with a list of columns.
    */
    void setColumns( const QList<Column>& columns );

    /**
    * Read the list of columns from the dialog.
    */
    QList<Column> columns() const;

signals:
    /**
    * Emitted when the Ok or Apply button is clicked.
    */
    void settingsApplied();

public: // overrides
    void accept();

private slots:
    void restoreDefaults();

    void availableSelected();
    void currentSelected();

    void addClicked();
    void removeClicked();
    void upClicked();
    void downClicked();

private:
    QList<Column> m_availableColumns;
    QList<Column> m_defaultColumns;

    int m_fixedColumns;

    QLabel* m_promptLabel;

    QListWidget* m_availableList;
    QListWidget* m_currentList;

    QToolButton* m_addButton;
    QToolButton* m_removeButton;
    QToolButton* m_upButton;
    QToolButton* m_downButton;

    QDialogButtonBox* m_buttonBox;
};

}

#endif
