/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef MEMBERSVIEW_H
#define MEMBERSVIEW_H

#include "view.h"

class QTreeView;
class QModelIndex;

namespace WebIssues
{

class TableItemModel;
class RowIndex;

/**
* View for displaying and managing members of a project.
*/
class MembersView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    MembersView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~MembersView();

public: // overrides
    void initialUpdate();

protected: // overrides
    void enableView();
    void disableView();

    void updateAccess( Access access );

    void updateEvent( UpdateEvent* e );

private slots:
    void updateActions();

    void updateMembers();
    void addMember();
    void changeAccess();
    void removeMember();

    void contextMenu( const QPoint& pos );
    void doubleClicked( const QModelIndex& index );

private:
    Access checkDataAccess();

    void updateCaption();

    QList<QModelIndex> selectedIndexes();

private:
    QTreeView* m_list;
    TableItemModel* m_model;

    QList<int> m_selectedUsers;

    bool m_projectAdmin;
};

}

#endif
