/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SEARCHEDITBOX_H
#define SEARCHEDITBOX_H

#include <QWidget>

class QLineEdit;
class QToolButton;

namespace WebIssues
{

/**
* An edit box with a clear button.
*
* The clear button is only enabled if the text is not empty.
*/
class SearchEditBox : public QWidget
{
    Q_OBJECT
public:
    /**
    * Conctructor.
    *
    * @param parent The parent widget.
    */
    SearchEditBox( QWidget* parent );

    /**
    * Destructor.
    */
    ~SearchEditBox();

public:
    /**
    * Set the text in the edit box.
    */
    void setText( const QString& text );

    /**
    * Return the text in the edit box.
    */
    QString text() const;

    /**
    * Clear the edit box.
    */
    void clear();

signals:
    /**
    * Emitted when the text in the edit box is changed.
    */
    void textChanged( const QString& text );

private slots:
    void slotTextChanged( const QString& text );
    void buttonClicked();

private:
    QLineEdit* m_edit;
    QToolButton* m_button;
};

}

#endif
