/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef CONNECTIONINFODIALOG_H
#define CONNECTIONINFODIALOG_H

#include <QDialog>

class QPushButton;

class PropertyPanel;

/**
* Connection information dialog.
*/
class ConnectionInfoDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    ConnectionInfoDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~ConnectionInfoDialog();

private slots:
    void viewCertificates();

private:
    void updateInformation();

private:
    PropertyPanel* m_serverPanel;
    PropertyPanel* m_userPanel;

    QPushButton* m_certificatesButton;
};

#endif
