/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef MANAGEFILTERSDIALOG_H
#define MANAGEFILTERSDIALOG_H

#include <QDialog>

class QLabel;
class QListWidget;
class QListWidgetItem;
class QDialogButtonBox;
class QMenu;

class ColumnConditionSettings;

/**
* Dialog for managing filters.
*/
class ManageFiltersDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param folderId Identifier of the folder.
    * @param parent The parent widget.
    */
    ManageFiltersDialog( int folderId, QWidget* parent );

    /**
    * Destructor.
    */
    ~ManageFiltersDialog();

private slots:
    void itemActivated( QListWidgetItem* item );
    void listContextMenu( const QPoint& pos );

    void newFilter();

    void modify();
    void rename();
    void remove();

private:
    void populateList();

    void modifyFilter( const QString& name );

private:
    int m_folderId;

    QListWidget* m_list;

    ColumnConditionSettings* m_settings;

    QMenu* m_menu;
};

#endif
