/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "csvreportwriter.h"

CsvReportWriter::CsvReportWriter()
{
}

CsvReportWriter::~CsvReportWriter()
{
}

void CsvReportWriter::writeRow( const QStringList& cells )
{
    m_rows.append( cells.join( "," ) );
}

QString CsvReportWriter::field( const QString& field )
{
    if ( field.startsWith( ' ' ) || field.endsWith( ' ' ) || field.contains( '"' )
        || field.contains( ',' ) || field.contains( '\n' ) || field == QLatin1String( "ID" ) ) {
        QString escaped = field;
        escaped.replace( "\"", "\"\"" );
        return '"' + escaped + '"';
    }
    return field;
}

QString CsvReportWriter::result() const
{
    return m_rows.join( "\r\n" );
}
