/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef FILTERVALUEEDITORS_H
#define FILTERVALUEEDITORS_H

#include "attributes/abstractvalueeditor.h"

/**
* Editor delegate for the operand of the age filter conditions.
*/
class AgeValueEditor : public AbstractValueEditor
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent Parent of the delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    */
    AgeValueEditor( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~AgeValueEditor();

public: // overrides
    void setValue( const QString& value );
    QString value();
};

#endif
