/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef DASHBOARDVIEW_H
#define DASHBOARDVIEW_H

#include "view.h"

class QTextBrowser;
class QUrl;

class FolderWatchProvider;

/**
* View showing the status of folder watches.
*/
class DashboardView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    DashboardView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~DashboardView();

public: // overrides
    void initialUpdate();

protected: // overrides
    void updateEvent( UpdateEvent* e );

    void viewEvent( ViewEvent* e );

private slots:
    void anchorClicked( const QUrl& url );

private:
    void updateWatchedFolders();
    void updateWatchedFolder( int folderId );

    void populateDashboard();

private:
    QTextBrowser* m_browser;

    FolderWatchProvider* m_provider;
};

#endif
