/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef USERSVIEW_H
#define USERSVIEW_H

#include "view.h"
#include "rdb/tableitemmodel.h"

class QTreeView;
class QModelIndex;

/**
* View for displaying and managing users.
*/
class UsersView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    UsersView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~UsersView();

public: // overrides
    void initialUpdate();

private slots:
    void updateActions();

    void updateUsers();
    void addUser();
    void editRename();
    void changeAccess();
    void changePassword();

    void contextMenu( const QPoint& pos );
    void activated( const QModelIndex& index );

private:
    QModelIndex selectedIndex();

private:
    QTreeView* m_list;
    RDB::TableItemModel* m_model;

    int m_selectedUserId;

    bool m_systemAdmin;
};

#endif
