/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef EDITLISTBOX_H
#define EDITLISTBOX_H

#include <QWidget>

class QListView;
class QStringListModel;
class QModelIndex;
class QLineEdit;
class QPushButton;

/**
* Widget for editing a list of strings.
*/
class EditListBox : public QWidget
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    EditListBox( QWidget* parent );

    /**
    * Destructor.
    */
    ~EditListBox();

public:
    /**
    * Set the list of strings.
    */
    void setStringList( const QStringList& list );

    /**
    * Return the list of string.
    */
    QStringList stringList() const;

    /**
    * Set the maximum length of entered strings.
    */
    void setMaxLength( int length );

public: // overrides
    QSize sizeHint() const;

private slots:
    void textChanged( const QString& text );

    void currentChanged( const QModelIndex& index );

    void addItem();
    void removeItem();
    void moveItemUp();
    void moveItemDown();

private:
    QListView* m_listView;
    QStringListModel* m_model;

    QLineEdit* m_lineEdit;

    QPushButton* m_addButton;
    QPushButton* m_removeButton;
    QPushButton* m_upButton;
    QPushButton* m_downButton;
};

#endif
