/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "popeditbox.h"

#include <QLabel>
#include <QPushButton>
#include <QLayout>

PopEditBox::PopEditBox( QWidget* parent ) : QFrame( parent )
{
    initialize();
}

PopEditBox::PopEditBox( const QString& text, QWidget* parent ) : QFrame( parent )
{
    initialize();
    m_label->setText( text );
}

PopEditBox::~PopEditBox()
{
}

void PopEditBox::initialize()
{
    setFrameStyle( StyledPanel | Sunken );

    QHBoxLayout* layout = new QHBoxLayout( this );
    layout->setMargin( 0 );
    layout->setSpacing( 0 );

    m_label = new QLabel( this );
    m_label->setTextFormat( Qt::RichText );
    m_label->setContentsMargins( 3, 2, 3, 2 );
    m_label->setSizePolicy( QSizePolicy::Ignored, QSizePolicy::Fixed );
    m_label->setContextMenuPolicy( Qt::CustomContextMenu );
    layout->addWidget( m_label, 1 );

    connect( m_label, SIGNAL( linkActivated( const QString& ) ),
        this, SIGNAL( linkClicked( const QString& ) ) );

    connect( m_label, SIGNAL( linkHovered( const QString& ) ),
        this, SLOT( labelLinkHovered( const QString& ) ) );
    connect( m_label, SIGNAL( customContextMenuRequested( const QPoint& ) ),
        this, SLOT( labelContextMenu( const QPoint& ) ) );

    m_button = new QPushButton( tr( "..." ), this );
    layout->addWidget( m_button, 0 );

    connect( m_button, SIGNAL( clicked() ), this, SIGNAL( buttonClicked() ) );

    m_label->setText( "X" );

    QSize size = m_label->sizeHint();
    m_button->setFixedSize( size.height() * 4 / 3, size.height() );

    m_label->clear();
}

void PopEditBox::setText( const QString& text )
{
    m_label->setText( text );
}

QString PopEditBox::text() const
{
    return m_label->text();
}

void PopEditBox::clear()
{
    m_label->clear();
}

void PopEditBox::labelLinkHovered( const QString& link )
{
    m_link = link;
}

void PopEditBox::labelContextMenu( const QPoint& pos )
{
    if ( !m_link.isEmpty() )
        emit linkContextMenu( m_link, m_label->mapToGlobal( pos ) );
}
