# cpan-lib.pl
# Functions for getting information about perl modules

do '../web-lib.pl';
&init_config();
require '../ui-lib.pl';
use Config;
$packages_file = "$module_config_directory/packages.txt.gz";

# Get the paths to perl and perldoc
$perl_path = &get_perl_path();
if (&has_command("perldoc")) {
	$perl_doc = &has_command("perldoc");
	}
else {
	$perl_path =~ /^(.*)\/[^\/]+$/;
	if (-x "$1/perldoc") {
		$perl_doc = "$1/perldoc";
		}
	}
if ($perl_doc && $] >= 5.006) {
	$perl_doc = "$perl_path -T $perl_doc";
	}

# list_perl_modules()
# Returns a list of all installed perl modules, by reading .packlist files
sub list_perl_modules
{
local (@rv, %done, $d, %donedir, %donemod);
foreach $d (&expand_usr64($Config{'privlib'}),
	    &expand_usr64($Config{'sitelib_stem'} ? $Config{'sitelib_stem'} :
				      		    $Config{'sitelib'}),
	    &expand_usr64($Config{'sitearch_stem'} ? $Config{'sitearch_stem'} :
				      		    $Config{'sitearch'}),
	    &expand_usr64($Config{'vendorlib_stem'} ? $Config{'vendorlib_stem'} :
				        	      $Config{'vendorlib'}),
	    &expand_usr64($Config{'installprivlib'})) {
	next if (!$d);
	next if ($donedir{$d});
	local $f;
	open(FIND, "find '$d' -name .packlist -print |");
	while($f = <FIND>) {
		chop($f);
		local @st = stat($f);
		next if ($done{$st[0],$st[1]}++);
		local @st = stat($f);
		local $mod = { 'date' => scalar(localtime($st[9])),
			       'packfile' => $f,
			       'index' => scalar(@rv) };
		$f =~ /\/(([A-Z][^\/]*\/)*[^\/]+)\/.packlist$/;
		$mod->{'name'} = $1;
		$mod->{'name'} =~ s/\//::/g;
		next if ($donemod{$mod->{'name'}}++);

		# Add the files in the .packlist
		local (%donefile, $l);
		open(FILE, $f);
		while($l = <FILE>) {
			chop($l);
			$l =~ s/^\/tmp\/[^\/]+//;
			$l =~ s/^\/var\/tmp\/[^\/]+//;
			next if ($donefile{$l}++);
			if ($l =~ /\/((([A-Z][^\/]*\/)([^\/]+\/)?)?[^\/]+)\.pm$/) {
				local $mn = $1;
				$mn =~ s/\//::/g;
				push(@{$mod->{'mods'}}, $mn);
				push(@{$mod->{'files'}}, $l);
				}
			elsif ($l =~ /^([^\/]+)\.pm$/) {
				# Module name only, with no path! Damn redhat..
				local @rpath;
				open(FIND2, "find '$d' -name '$l' -print |");
				while(<FIND2>) {
					chop;
					push(@rpath, $_);
					}
				close(FIND2);
				@rpath = sort { length($a) cmp length($b) } @rpath;
				if (@rpath) {
					$rpath[0] =~ /\/(([A-Z][^\/]*\/)*[^\/]+)\.pm$/;
					local $mn = $1;
					$mn =~ s/\//::/g;
					push(@{$mod->{'mods'}}, $mn);
					push(@{$mod->{'files'}}, $rpath[0]);
					$mod->{'noremove'} = 1;
					}
				}
			push(@{$mod->{'packlist'}}, $l);
			}
		close(FILE);
		local $mi = &indexof($mod->{'name'}, @{$mod->{'mods'}});
		$mod->{'master'} = $mi < 0 ? 0 : $mi;
		push(@rv, $mod) if (@{$mod->{'mods'}});
		}
	close(FIND);
	}

# Look for RPMs for Perl modules
if (&foreign_check("software")) {
	&foreign_require("software", "software-lib.pl");
	if ($software::config{'package_system'} eq "rpm") {
		local $n = &software::list_packages();
		local $i;
		for($i=0; $i<$n; $i++) {
			# Create the module object
			next if ($software::packages{$i,'name'} !~
				 /^perl-([A-Z].*)$/);
			local $mod = { 'index' => scalar(@rv),
				       'rpm' => $software::packages{$i,'name'},
				       'noremove' => 1 };
			$mod->{'name'} = $1;
			$mod->{'name'} =~ s/\-/::/g;
			next if ($donemod{$mod->{'name'}}++);

			# Add the files in the RPM
			local $fn = &software::check_files(
				$software::packages{$i,'name'},
				$software::packages{$i,'version'});
			local $fi;
			for($fi=0; $fi<$fn; $fi++) {
				local $l = $software::files{$fi,'path'};
				if ($l =~ /\/((([A-Z][^\/]*\/)([^\/]+\/)?)?[^\/]+)\.pm$/) {
					local $mn = $1;
					$mn =~ s/\//::/g;
					push(@{$mod->{'mods'}}, $mn);
					push(@{$mod->{'files'}}, $l);
					}
				push(@{$mod->{'packlist'}}, $l);
				if (!$mod->{'date'}) {
					local @st = stat($l);
					$mod->{'date'} = scalar(localtime($st[9]));
					}
				}

			local $mi = &indexof($mod->{'name'}, @{$mod->{'mods'}});
			$mod->{'master'} = $mi < 0 ? 0 : $mi;
			push(@rv, $mod) if (@{$mod->{'mods'}});
			}
		}
	}

return @rv;
}

# expand_usr64(dir)
# If a directory is like /usr/lib and /usr/lib64 exists, return them both
sub expand_usr64
{
if ($_[0] =~ /^(\/usr\/lib\/|\/usr\/local\/lib\/)(.*)$/) {
	local ($dir, $dir64, $rest) = ($1, $1, $2);
	$dir64 =~ s/\/lib\//\/lib64\//;
	return -d $dir64 ? ( $dir.$rest, $dir64.$rest ) : ( $dir.$rest );
	}
else {
	return ( $_[0] );
	}
}

# module_desc(&mod, index)
# Returns a one-line description for some module, and a version number
sub module_desc
{
local ($in_name, $desc);
local $f = $_[0]->{'files'}->[$_[1]];
local $pf = $f;
local $ver;
$pf =~ s/\.pm$/\.pod/;
local ($got_version, $got_name);
open(MOD, $pf) || open(MOD, $f);
while(<MOD>) {
	if (/^=head1\s+name/i && !$got_name) {
		$in_name = 1;
		}
	elsif (/^=/ && $in_name) {
		$got_name++;
		$in_name = 0;
		}
	elsif ($in_name) {
		$desc .= $_;
		}
	if (/^\s*\$VERSION\s*=\s*"([0-9\.]+)"/ ||
	    /^\s*\$VERSION\s*=\s*'([0-9\.]+)'/ ||
	    /^\s*\$VERSION\s*=\s*([0-9\.]+)/) {
		$ver = $1;
		$got_version++;
		}
	last if ($got_version && $got_name);
	}
close(MOD);
local $name = $_[0]->{'mods'}->[$_[1]];
$desc =~ s/^\s*$name\s+\-\s+// ||
	$desc =~ s/^\s*\S*<$name>\s+\-\s+//;
$desc =~ s/\$Id:.*\$//;
return wantarray ? ($desc, $ver) : $desc;
}

# download_packages_file(&callback)
sub download_packages_file
{
$config{'packages'} =~ /^http:\/\/([^\/]+)(\/.*)$/ ||
	&error($text{'download_epackages'});
local ($host, $page, $port) = ($1, $2, 80);
if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
&http_download($host, $port, $page, $packages_file, undef, $_[0]);
}

1;

