#!/usr/local/bin/perl
# hide_form.cgi
# Build up a list of modules that should be hidden due to their managed
# servers not being installed

require './acl-lib.pl';
&ReadParse();
&can_edit_user($in{'user'}) || &error($text{'edit_euser'});
&header($text{'hide_title'}, "");
print "<hr>\n";

# Find modules to hide which the user has and which theoretically support
# this OS
&read_acl(\%acl);
foreach $m (sort { $a->{'desc'} cmp $b->{'desc'} }
	    &get_all_module_infos()) {
	if (&check_os_support($m) && $acl{$in{'user'},$m->{'dir'}} &&
	    !&foreign_installed($m->{'dir'}, 0)) {
		push(@hide, $m);
		}
	}

if (@hide) {
	print "<form action=hide.cgi>\n";
	print "<input type=hidden name=user value='$in{'user'}'>\n";
	print &text('hide_desc', "<tt>$in{'user'}</tt>"),"<br>\n";
	print "<ul>\n";
	foreach $h (@hide) {
		print "<li>$h->{'desc'}\n";
		if ($h->{'clone'}) {
			print &text('hide_clone', "<tt>$h->{'dir'}</tt>"),"\n";
			}
		print "<input type=hidden name=hide value='$h->{'dir'}'>\n";
		}
	print "</ul><p>\n";
	print "$text{'hide_desc2'}<p>\n";
	print "<input type=submit value='$text{'hide_ok'}'></form>\n";
	}
else {
	print &text('hide_none', "<tt>$in{'user'}</tt>"),"<p>\n";
	}

print "<hr>\n";
&footer("edit_user.cgi?user=$in{'user'}", $text{'user_return'},
	"", $text{'index_return'});

