#!/usr/local/bin/perl
# change-passwd.pl
# Changes a user's password using the Users and Groups module. Also changes
# the password in other modules.

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/change-passwd.pl";
do './passwd-lib.pl';

if ($ARGV[0] eq "--old" || $ARGV[0] eq "-old") {
	$askold = 1;
	shift(@ARGV);
	}
@ARGV == 1 || &errordie("usage: change-passwd.pl [-old] <username>");
if (&foreign_installed("useradmin") != 1) {
	&errordie("Users and Groups module is not supported on this OS");
	}

# Find the user
&foreign_require("useradmin", "user-lib.pl");
@ulist = &useradmin::list_users();
($user) = grep { $_->{'user'} eq $ARGV[0] } @ulist;
$user || &errordie("User $ARGV[0] does not exist");

$| = 1;
if ($askold) {
	# Ask for the old password
	print "(current) UNIX password: ";
	$old = <STDIN>;
	$old =~ s/\r|\n//g;
	crypt($old, $user->{'pass'}) eq $user->{'pass'} ||
		&errordie("Old password is incorrect");
	}

# Ask for password
print "New password: ";
$pass = <STDIN>;
$pass =~ s/\r|\n//g;
print "Retype new password: ";
$again = <STDIN>;
$again =~ s/\r|\n//g;
$pass eq $again || &errordie("Passwords don't match");

# Check password sanity
$err = &useradmin::check_password_restrictions($pass, $ARGV[0]);
&errordie($err) if ($err);

# Do the change!
$user->{'olduser'} = $user->{'user'};
$user->{'pass'} = &useradmin::encrypt_password($pass);
$user->{'passmode'} = 3;
$user->{'plainpass'} = $pass;
$pft = &useradmin::passfiles_type();
if ($pft == 2 || $pft == 5) {
	if ($in{'expire'}) {
		$user->{'change'} = 0;
		}
	else {
		$user->{'change'} = int(time() / (60*60*24));
		}
	}
elsif ($pft == 4) {
	$user->{'change'} = time();
	}
&useradmin::lock_user_files();
&useradmin::set_user_envs($user, 'MODIFY_USER', $pass);
&useradmin::making_changes();
&useradmin::modify_user($user, $user);
&useradmin::made_changes();
&useradmin::unlock_user_files();
&useradmin::other_modules("useradmin_modify_user", $user);

# All done
exit(0);

sub errordie
{
print STDERR @_,"\n";
exit(1);
}

