#!/usr/local/bin/perl
# Create and output a wbm.gz file of selected modules

require './webmin-lib.pl';
&ReadParse();
&error_setup($text{'export_err'});
@mods = split(/\0/, $in{'mod'});
@mods || &error($text{'delete_enone'});

# Make sure we have the needed commands
&has_command("tar") || &error(&text('export_ecmd', "<tt>tar</tt>"));
&has_command("gzip") || &error(&text('export_ecmd', "<tt>gzip</tt>"));

# Make the tar.gz file
$temp = &transname();
chdir(&module_root_directory($mods[0])."/..");
$cmd = "tar chf -";
foreach $m (@mods) {
	$cmd .= " $m";
	}
$cmd .= " | gzip -c >$temp";
$out = &backquote_logged("($cmd) 2>&1 </dev/null");
$? && &error("<pre>$out</pre>");

# Output the file
print "Content-type: application/octet-stream\n\n";
open(TEMP, $temp);
while(<TEMP>) {
	print $_;
	}
close(TEMP);
unlink($temp);

