/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

void WebXml::init()
{
    lvServlets->setColumnWidthMode(0, QListView::Manual);
    lvServlets->setColumnWidth ( 0, lvServlets->width() );
  //  table->insertRows(table->numRows());
  //  table->setColumnWidth(1,table->width());
    lvServlets->setSorting(-1);  
    servlets=new QPtrList<ServletEntry>;
    currIndex=-1;
    fullFileName="";
    changed=false;
    GUIReadOnly(true);
    printer=new QPrinter;
    wdd=new WDDEntries();
}

void WebXml::fileNew()
{
    WDForm *wdf=new WDForm;
    wdf->tblWelcome->setEnabled(false);
    wdf->tblErrors->setEnabled(false);
    if(wdf->exec()==QDialog::Accepted)
    {
	//qDebug("Accepted "+ wdf->txtDisplayName->text());
	wdd=new WDDEntries();
	wdd->setDisplayName(wdf->txtDisplayName->text());
	wdd->setSessionTimeOut(wdf->sbSessionTimeout->value());
	int prs=wdf->tblParams->numRows();
	for(int i=0; i< prs;i++)
	    wdd->getParameters()->append(new CtxParameter(wdf->tblParams->text(i,0),wdf->tblParams->text(i,1),wdf->tblParams->text(i,2)));
	/****** Files Tab handler *******/
	wdd->setEnaWelcome(false);
	if(wdf->cbWelcome->isChecked())
	{
		//Welcome file list enabled
	    //qDebug("Welcome file list");
		prs=wdf->tblWelcome->numRows();
		for(int i=0; i< prs; i++)
		{
		    if(wdf->tblWelcome->text(i, 0).stripWhiteSpace()!="")
		    {
			//qDebug("Valid WF"+wdf->tblWelcome->text(i, 0).stripWhiteSpace());
			wdd->setEnaWelcome(true);
			wdd->getWelcomeFiles()->append(wdf->tblWelcome->text(i, 0).stripWhiteSpace());
		    }
		} 
		 for ( QStringList::Iterator it = wdd->getWelcomeFiles()->begin(); it != wdd->getWelcomeFiles()->end(); ++it )
		{
		//qDebug(*it);
	               }
	}
	wdd->setEnaErrorPages(false);
	if(wdf->cbErrors->isChecked())
	{
		//Errors file list enabled
		prs=wdf->tblErrors->numRows();
		for(int i=0; i< prs; i++)
		{
		    if(wdf->tblErrors->text(i, 0).stripWhiteSpace()!="")
		    {
			bool fl=true;
			wdf->tblErrors->text(i, 0).stripWhiteSpace().toInt(&fl);
			if(fl)
			{
			    wdd->setEnaErrorPages(true);
			    wdd->getErrorPages()->insert(wdf->tblErrors->text(i, 0).stripWhiteSpace(), wdf->tblErrors->text(i, 1).stripWhiteSpace());
			}
		    }
		}
	}
    }
    else
	qDebug("Rejected");
    delete wdf;
    clearAll();
    currIndex=-1;
    fullFileName="";
    servlets=new QPtrList<ServletEntry>;
    changed=false;
    newServlet();
    GUIReadOnly(false);
}

void WebXml::fileOpen()
{
    QDomDocument domTree;
    QString fileName = QFileDialog::getOpenFileName( QString::null, QString::null, this );
    if ( fileName.isEmpty() )
    {
        return;
    }
    fullFileName=fileName;
    classesDir=fileName.mid(0, fileName.findRev(QDir::separator())+1);
    // read the XML file and create DOM tree
    QFile opmlFile( fileName );
    if ( !opmlFile.open( IO_ReadOnly ) ) {
        QMessageBox::critical( 0,
                tr( "Critical Error" ),
                tr( "Cannot open file %1" ).arg( fileName ) );
        return;
    }
    if ( !domTree.setContent( &opmlFile ) ) {
        QMessageBox::critical( 0,
                tr( "Critical Error" ),
                tr( "Parsing error for file %1" ).arg( fileName ) );
        opmlFile.close();
        return;
    }
    opmlFile.close();
    clearAll();
    servlets=new QPtrList<ServletEntry>;
    currIndex=-1;
    // get the header information from the DOM
    QDomElement root = domTree.documentElement();
    //qDebug(root.tagName());
    QDomNodeList wddList=root.childNodes();
    if(!wdd)
	wdd=new WDDEntries();
    for(int i=0; i<wddList.length();i++)
    {
	//qDebug("D-N: "+wddList.item(i).nodeName());
	//qDebug("\tD-N: "+wddList.item(i).firstChild().nodeValue());
	QString nodeName=wddList.item(i).nodeName().lower();
	if(nodeName=="display-name")
	    wdd->setDisplayName(wddList.item(i).firstChild().nodeValue());
	if(nodeName=="context-param")
	{
		if(wddList.item(i).hasChildNodes())
		   wdd->getParameters()->append(readCtxParams(wddList.item(i)));
	}
	if(nodeName=="session-config")
	{
	     if(wddList.item(i).hasChildNodes())
		wdd->setSessionTimeOut(readSessionTimeout(wddList.item(i)));
	 }
	if(nodeName=="welcome-file-list")
	{
		readWelcomeFiles( wdd->getWelcomeFiles(), wddList.item(i));
	    }
	if(nodeName=="error-page")
	{
		if(wddList.item(i).hasChildNodes())
		{
		   readErrorPage(wdd->getErrorPages(), wddList.item(i));
		}
	}
    }
    if(wdd->getErrorPages()->count()>0)
	wdd->setEnaErrorPages(true);    
    if(wdd->getWelcomeFiles()->count()>0)
	wdd->setEnaWelcome(true);  
    
    QDomNodeList nodeList=root.elementsByTagName("servlet");
    ServletEntry *se, *tmp;
    QPtrListIterator <ServletEntry> it(*servlets);
    for(int i=0; i< nodeList.length(); i++)
    {
	se=new ServletEntry();
	se->setServletName(nodeList.item(i).namedItem("servlet-name").firstChild().nodeValue());
	//qDebug(nodeList.item(i).namedItem("servlet-name").firstChild().nodeValue());
	//qDebug(nodeList.item(i).namedItem("servlet-class").firstChild().nodeValue());
	se->setServletClass(nodeList.item(i).namedItem("servlet-class").firstChild().nodeValue());
	//qDebug(nodeList.item(i).namedItem("display-name").firstChild().nodeValue());
	se->setDisplayName(nodeList.item(i).namedItem("display-name").firstChild().nodeValue());
	//qDebug(nodeList.item(i).namedItem("load-on-startup").firstChild().nodeValue());
	se->setLoadOnStartup(nodeList.item(i).namedItem("load-on-startup").firstChild().nodeValue());
	//qDebug(nodeList.item(i).namedItem("description").firstChild().nodeValue());
	se->setDescription(nodeList.item(i).namedItem("description").firstChild().nodeValue());
	QDomNodeList initList=nodeList.item(i).toElement().elementsByTagName("init-param");
	for(int j=0; j<initList.length();j++)
	{
	    //qDebug("\t"+initList.item(j).namedItem("param-name").firstChild().nodeValue());
	   // qDebug("\t"+initList.item(j).namedItem("param-value").firstChild().nodeValue());
	    se->setInitParam(initList.item(j).namedItem("param-name").firstChild().nodeValue(), initList.item(j).namedItem("param-value").firstChild().nodeValue());
	}
	servlets->append(se);
    }
    nodeList=root.elementsByTagName("servlet-mapping");
    
    for(int i=0; i< nodeList.length(); i++)
    {
	tmp=it.toFirst();
	QString servletName=nodeList.item(i).namedItem("servlet-name").firstChild().nodeValue();
	while((tmp=it.current())!=0)
	{
	    if(tmp->getServletName()==servletName)
	    {
	//qDebug("Found"+nodeList.item(i).namedItem("servlet-name").firstChild().nodeValue());
	//qDebug("FVal:"+nodeList.item(i).namedItem("url-pattern").firstChild().nodeValue());

		it.current()->setURLPattern(nodeList.item(i).namedItem("url-pattern").firstChild().nodeValue());
		break;
	    }
	    ++it;
	}
    }
    fillGUI();
    GUIReadOnly(false);
}

void WebXml::fileSave()
{
    qDebug("Full file name: "+fullFileName);
    saveDOM();
}

void WebXml::fileSaveAs()
{
    QString fileName = QFileDialog::getSaveFileName( webInfDir, "web.xml", this, "save web.xml", "Save web.xml file" );
    if ( fileName.isEmpty() )
    {
	return;
    }
    else
	fullFileName=fileName;    
    saveDOM();
}

void WebXml::filePrint()
{
    const int Margin = 10;
    int pageNo = 1;
    QString str;
    QTextStream t( &str, IO_WriteOnly );
    if(changed)
	updateAllValues();
    //QTextCodec *codec = QTextCodec::codecForName("KOI8-R"); // get the codec for KOI8-R
    //t.setCodec(codec);
    t << "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" << "\n";
    t << "<!DOCTYPE web-app" << "\n";
    t << "PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"" << "\n";
    t << "\"http://java.sun.com/dtd/web-app_2_3.dtd\">" << "\n";
    t << "<!-- WDD file generated/edited by webxml utility (http://webxml.sf.net). Author: Boulgakov Andrei -->" << "\n";
    
    t << doDoc() << "\n";
    
    if ( printer->setup(this) ) {               // printer dialog
        statusBar()->message( "Printing..." );
        QPainter p;
        if( !p.begin( printer ) )               // paint on printer
            return;

     //   p.setFont( e->font() );
        int yPos        = 0;                    // y-position for each line
        QFontMetrics fm = p.fontMetrics();
        QPaintDeviceMetrics metrics( printer ); // need width/height
                                                // of printer surface
        if ( Margin + yPos > metrics.height() - Margin ) {
                QString msg( "Printing (page " );
                msg += QString::number( ++pageNo );
                msg += ")...";
                statusBar()->message( msg );
                printer->newPage();             // no more room on this page
                yPos = 0;                       // back to top of page
            }
	  //  qDebug("PRINT: "+str);
            p.drawText( Margin, Margin + yPos,
                        metrics.width(), fm.lineSpacing(),
                        ExpandTabs | DontClip,
                        str );
            yPos = yPos + fm.lineSpacing();
      
        p.end();                                // send job to printer
        statusBar()->message( "Printing completed", 2000 );	
    } else {
        statusBar()->message( "Printing aborted", 2000 );
    }
}

void WebXml::fileExit()
{
    if(changed)
    {
	int res=QMessageBox::critical(this, tr("File was changed."), tr("Do you want to save changes?"), tr("OK"), tr("No"), tr("Cancel"), 0, 2);
	switch(res)
	{
	    case 0: saveDOM();break;
	    case 1: break;
	    case 2: return;
	}
    }
    close();
}


void WebXml::fillGUI()
{
    ServletEntry *se;
    QPtrListIterator <ServletEntry> it(*servlets);
    if(it.count()>0)
    {
	se=it.toFirst();
	QListViewItem *after = new QListViewItem(lvServlets, se->getServletName());
	after->setRenameEnabled ( 0, true );
	//qDebug("fillGUI: "+se->getServletName());
	++it;
	while((se=it.current())!=0)
	{
	   // qDebug("fillGUI in while : "+se->getServletName());
	    after=new QListViewItem(lvServlets, after, se->getServletName());
	    after->setRenameEnabled ( 0, true );
	    ++it;
	}
    }
}


void WebXml::newServlet()
{
    clearProperties();
    GUIReadOnly(false);
    ServletEntry *se=new ServletEntry();
    servlets->append(se);
    QListViewItem *last=lvServlets->lastItem();
    QListViewItem *li= new QListViewItem(lvServlets, last,  "New Servlet");
    currIndex=li->itemPos()/li->height();
    li->setRenameEnabled ( 0, true );
    li->startRename(0);
    
}

void WebXml::delServlet()
{
    QListViewItem *li=lvServlets->selectedItem();
    if(li!=0)
    {
	int index=li->itemPos()/li->height();
	servlets->remove(index);
	lvServlets->takeItem(li);
	clearProperties();
    }
    if(lvServlets->childCount() <= 0)
    {
	//clearAll();
	GUIReadOnly(true);
	editAddServlet->setEnabled(true);
	editWDDEntries->setEnabled(true);
	
    }
}

void WebXml::lvServlets_itemRenamed( QListViewItem *li, int, const QString & text)
{
    if(li!=0)
    {
	int index=li->itemPos()/li->height();
	servlets->at(index)->setServletName(text);
	txtServletName->setText(text);
    }
}

void WebXml::clearProperties()
{
    txtServletName->setText("");
    txtDisplayName->setText("");
    txtServletClass->setText("");
    txtURLPattern->setText("");
    txtDescription->setText("");
    int nR=table->numRows();
    for(int i=0;i < nR; i++)
    {
	table->removeRow(0);
    }
    spinbox->setValue(0);
    currIndex=-1;
}

void WebXml::newParameter()
{
     table->insertRows(table->numRows());
     table->editCell(table->numRows()-1, 0);
}

void WebXml::delParameter()
{
    table->removeRow(table->currentRow ());
    //Remvoe from servlets-InitPArams too....
}

void WebXml::updateInitParams()
{
    //qDebug("Update InitParams");
    servlets->at(currIndex)->clearInitParams();
    for(int i=0 ;i<table->numRows() ; i++)
    {
	servlets->at(currIndex)->setInitParam(table->text(i,0),table->text(i, 1));
    }
}

void WebXml::btBrowse_clicked()
{
    QString fn = QFileDialog::getOpenFileName(classesDir, "JAVA Classes (*.class)", this, "choose class","Servlet class" );
    int ind;
    if ( !fn.isEmpty() )
    {
	QString pattern=QString("WEB-INF").append(QDir::separator()).append("classes");
	if((ind=fn.findRev(pattern))==-1)
	{
	    QMessageBox::critical(this, "Wrong Servlet directory", "The class choosen is not under Tomcat servlet directory: "+fn, QMessageBox::Ok, QMessageBox::NoButton);
	    return;
	}
	classesDir=fn.mid(0, fn.findRev(QDir::separator())+1);
	webInfDir=fn.mid(0, ind+QString("WEB-INF").length()+1);
	fn=fn.mid(ind+pattern.length()).replace(QRegExp(QString("").append(QDir::separator())), ".");
	fn=fn.mid(1, fn.length()-7);
	txtServletClass->setText( fn );
    }
    //else
	//txtServletClass->setText("");
}

void WebXml::updateAllValues()
{
    if(currIndex>-1)
    {
	servlets->at(currIndex)->setServletName(txtServletName->text());
	servlets->at(currIndex)->setDisplayName(txtDisplayName->text());
	servlets->at(currIndex)->setServletClass(txtServletClass->text());
	servlets->at(currIndex)->setDescription(txtDescription->text());
	servlets->at(currIndex)->setURLPattern(txtURLPattern->text());
	servlets->at(currIndex)->setLoadOnStartup(QString::number(spinbox->value()));
	updateInitParams(currIndex);
    }
}

void WebXml::updateInitParams( int index )
{
    servlets->at(index)->clearInitParams();
    for(int i=0 ;i<table->numRows() ; i++)
    {
	servlets->at(index)->setInitParam(table->text(i,0),table->text(i, 1));
    }
}

void WebXml::GUIReadOnly( bool flag )
{
    txtDisplayName->setReadOnly(flag);
    txtServletClass->setReadOnly(flag);
    txtURLPattern->setReadOnly(flag);
    btBrowse->setEnabled(!flag);
    spinbox->setEnabled(!flag);
    txtDescription->setReadOnly(flag);
    lvServlets->setEnabled(!flag);
    filePreviewAction->setEnabled(!flag);
    filePrintAction->setEnabled(!flag);
    fileSaveAction->setEnabled(!flag);
    fileSaveAsAction->setEnabled(!flag);
    editDelServlet->setEnabled(false);
    table->setEnabled(!flag);
    
    editAddServlet->setEnabled(!flag);
    editWDDEntries->setEnabled(!flag);
}

void WebXml::clearAll()
{
    clearProperties();
    lvServlets->clear();
    delete servlets;
    currIndex=-1;
}

void WebXml::saveDOM()
{
    QString fileName;
    if(changed)
	updateAllValues();
    if(fullFileName=="")
    {
	fileName = QFileDialog::getSaveFileName( webInfDir, "web.xml", this, "save web.xml", "Save web.xml file" );
	if ( fileName.isEmpty() )
	{
	    return;
	}
    }
    else
	fileName=fullFileName;    
   
    
    QFile f( fileName );
    if ( !f.open( IO_WriteOnly ) )
        return;
    QTextStream t( &f );
    //QTextCodec *codec = QTextCodec::codecForName("KOI8-R"); // get the codec for KOI8-R
    //t.setCodec(codec);
    t << "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" << "\n";
    t << "<!DOCTYPE web-app" << "\n";
    t << "PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"" << "\n";
    t << "\"http://java.sun.com/dtd/web-app_2_3.dtd\">" << "\n";
    t << "<!-- WDD file generated/edited by webxml utility (http://webxml.sf.net). Author: Boulgakov Andrei -->" << "\n";
    //t <<xml << "\n";
    
    t << doDoc() << "\n";
    f.close();
}

QDomElement  WebXml::addNode( QDomElement *parent, QString element, QString text )
{
    QDomDocument doc;
    QDomElement tag = doc.createElement (element);
    parent->appendChild (tag );
    QDomText domTxt = doc.createTextNode( text );
    tag.appendChild( domTxt );
    return tag;
}

void WebXml::txtDisplayName_textChanged( const QString & )
{
    if(currIndex==-1)
	statusBar()->message( "Select Servlet to edit!", 2000 );
    else
	changed=true;
}

void WebXml::txtServletClass_textChanged( const QString & )
{
    if(currIndex==-1)
	statusBar()->message( "Select Servlet to edit!", 2000 );
    else
	changed=true;
}

void WebXml::txtURLPattern_textChanged( const QString & )
{
    if(currIndex==-1)
	statusBar()->message( "Select Servlet to edit!", 2000 );
    else
	changed=true;
}

void WebXml::table_valueChanged( int, int )
{
    if(currIndex==-1)
	statusBar()->message( "Select Servlet to edit!", 2000 );
    else
	changed=true;
}

void WebXml::spinbox_valueChanged( int )
{
    if(currIndex==-1)
	statusBar()->message( "Select Servlet to edit!", 2000 );
    else
	changed=true;
}

void WebXml::txtDescription_textChanged()
{
    if(currIndex==-1)
	statusBar()->message( "Select Servlet to edit!", 2000 );
    else
	changed=true;
}

QString WebXml::doDoc()
{
    
    QDomDocument doc;
    QDomElement root;
    QDomElement serv;
    QDomElement tag;
    QDomText domTxt;
    int _cnt;
    // Root Node start
    root = doc.createElement( "web-app" );
    doc.appendChild( root );  //ROOT
    if(wdd)
    {
	if(wdd->getDisplayName()!="")
	    (void)addNode( &root, "display-name", wdd->getDisplayName());
	if(wdd->getSessionTimeOut()>-2)
	{
	    serv=addNode( &root, "session-config", "\n");
	    (void)addNode( &serv, "session-timeout", QString::number(wdd->getSessionTimeOut()));
	}
	if((_cnt=wdd->getParameters()->count())>0)
	{
	    for(int i=0; i<_cnt; i++)
	    {
		serv=addNode( &root, "context-param", "\n");
		(void)addNode( &serv, "param-name", wdd->getParameters()->at(i)->getParamName());
		(void)addNode( &serv, "param-value", wdd->getParameters()->at(i)->getParamValue());
		(void)addNode( &serv, "description", wdd->getParameters()->at(i)->getParamDescription());
	    }
	}
	if((_cnt=wdd->getWelcomeFiles()->count())>0)
	{
	    serv=addNode( &root, "welcome-file-list","\n");
	    for ( QStringList::Iterator it = wdd->getWelcomeFiles()->begin(); it != wdd->getWelcomeFiles()->end(); ++it ) 	    	    {
		(void)addNode( &serv, "welcome-file", *it);
                   }
	}
	if(wdd->getErrorPages()->count()>0)
	{
	    QMap<QString, QString>::Iterator it;
	     for ( it = wdd->getErrorPages()->begin(); it != wdd->getErrorPages()->end(); ++it ) 
	     {
		 serv=addNode( &root, "error-page", "\n");
		 (void)addNode( &serv, "error-code", it.key().latin1());
		 (void)addNode( &serv, "location",  it.data().latin1());
	      }
	}
	
    }
    if(!servlets->isEmpty())
    {
	ServletEntry *se;
	QMap<QString, QString> initParams;
	for( se=servlets->first(); se ; se = servlets->next())
	{
	    serv=addNode( &root, "servlet","\n" );
	    tag=addNode(&serv, "servlet-name",se->getServletName().latin1());
	    tag=addNode(&serv, "servlet-class",se->getServletClass().latin1());
	    tag=addNode(&serv, "display-name",se->getDisplayName().latin1());
	    tag=addNode(&serv, "description",se->getDescription().latin1());
	    if(se->getLoadOnStartup() != "0")
		tag=addNode(&serv, "load-on-startup",se->getLoadOnStartup().latin1());
	    initParams=se->getInitParameters();
	    if(initParams.count() > 0 )
	    {
		QMap<QString, QString>::Iterator it;
		for(it=initParams.begin(); it!=initParams.end(); ++it)
		{
		    tag=addNode(&serv, "init-param","\n");
		    (void)addNode(&tag, "param-name", it.key().latin1());
		    (void)addNode(&tag, "param-value", it.data().latin1());
		}
	    }
	 }
	for( se=servlets->first(); se ; se = servlets->next())
	{
	   // Servlet mapping
	    serv=addNode( &root, "servlet-mapping","\n" );
	    addNode(&serv, "servlet-name",se->getServletName().latin1());
	    addNode(&serv, "url-pattern",se->getURLPattern().latin1());
	}
    }
    return doc.toString();
}



void WebXml::showAbout()
{
    QMessageBox::about(this, "WebXml Utility", "WebXml is an utility for generating/editing simple Tomcat's web.xml file.\nhttp://webxml.sf.net");
}

void WebXml::lvServlets_contextMenuRequested( QListViewItem *li, const QPoint &p, int )
{
    //qDebug("ContextMenuRequested");
    QPopupMenu *menu=new QPopupMenu();
    menu->insertItem("Add new Servlet", this, SLOT(newServlet()));
    if(li!=0)
    {
	menu->insertSeparator();
	menu->insertItem("Delete this Servlet", this, SLOT(delServlet()));
    }
    menu->popup(p);
    
}


void WebXml::lvServlets_selectionChanged( QListViewItem *li )
{
    //qDebug("selectionChanged");
        if(currIndex!=-1)
    {
	updateAllValues();
//	updateInitParams();
    }
   
    if(li!=0)
    {
	//qDebug("Height:"+QString::number(li->height()));
	//qDebug(QString("Depth:(%1), ").arg(li->depth())+QString("itemPos: (%1)").arg(li->itemPos()));
	editDelServlet->setEnabled(true);
	int index=li->itemPos()/li->height();
	currIndex=index;
	txtServletName->setText(servlets->at(index)->getServletName());
	txtDisplayName->setText(servlets->at(index)->getDisplayName());
	txtServletClass->setText(servlets->at(index)->getServletClass());
	txtURLPattern->setText(servlets->at(index)->getURLPattern());
	spinbox->setValue(servlets->at(index)->getLoadOnStartup().toInt());
	txtDescription->setText(servlets->at(index)->getDescription());
	//table
	table->setEnabled(true);
	if(table->numRows()>0)
	{
	    //qDebug("Rows:"+QString::number(table->numRows()));
	    int nR=table->numRows();
	    for(int i=0;i < nR; i++)
	    {
		//qDebug("REM row "+QString::number(i));
		table->removeRow(0);
	    }
	}
	QMap<QString, QString>initParams=servlets->at(index)->getInitParameters();
	QMap<QString, QString>::Iterator it;
	for ( it = initParams.begin(); it != initParams.end(); ++it ) 
	{
	    
	    table->insertRows(table->numRows());
	    // table->verticalHeader()->setLabel(table->numRows() ,QString::number(table->numRows()));
	    //qDebug(it.key()+"="+it.data());
	     table->setText(table->numRows()-1, 0, it.key());
	     table->setText(table->numRows()-1, 1, it.data());
	     
	 }
    }
    else
    {
	editDelServlet->setEnabled(false);
    }
}


void WebXml::table_contextMenuRequested( int row, int, const QPoint & )
{
    if(currIndex==-1)
	return;
    QPopupMenu *menu=new QPopupMenu();
    menu->insertItem("Add new parameter", this, SLOT(newParameter()));
    if(row!=-1)
	menu->insertItem("Delete parameter", this, SLOT(delParameter()));
    menu->popup(QCursor::pos());
}


void WebXml::editWDD()
{
    if(!wdd)
	wdd=new WDDEntries();
    if(wdd)
    {
	WDForm *wdf=new WDForm;
	wdf->tblWelcome->setEnabled(false);
	wdf->tblErrors->setEnabled(false);
	wdf->txtDisplayName->setText(wdd->getDisplayName());
	wdf->sbSessionTimeout->setValue(wdd->getSessionTimeOut());
	//wdd->getParameters()->append(new CtxParameter("Key","Value","Description"));
	int prs=wdd->getParameters()->count();
	if(prs>0)
	{
	    wdf->tblParams->setNumRows(prs);
	    for (int i=0; i< prs ; i++)
	    {
		wdf->tblParams->setText(i, 0, wdd->getParameters()->at(i)->getParamName());
		wdf->tblParams->setText(i, 1, wdd->getParameters()->at(i)->getParamValue());
		wdf->tblParams->setText(i, 2, wdd->getParameters()->at(i)->getParamDescription());
	    }
	}
	/****** Files Tab SET handler ********/
	if(wdd->getEnaWelcome())
	{
	    //Welcome file list
	    wdf->cbWelcome->setChecked(true);
 	    wdf->tblWelcome->setEnabled(true);
	    for ( QStringList::Iterator it = wdd->getWelcomeFiles()->begin(); it != wdd->getWelcomeFiles()->end(); ++it ) 	          {
		//qDebug(*it);
		wdf->tblWelcome->insertRows(0);
		wdf->tblWelcome->setText(0, 0, *it);
                   }
	}
	if(wdd->getEnaErrorPages())
	{
	    //Error pages
	    wdf->cbErrors->setChecked(true);
	    wdf->tblErrors->setEnabled(true);
	     QMap<QString, QString>::Iterator it;
	     for ( it = wdd->getErrorPages()->begin(); it != wdd->getErrorPages()->end(); ++it ) 
	     {
		 wdf->tblErrors->insertRows(0);
		 wdf->tblErrors->setText(0, 0, it.key().latin1());
		 wdf->tblErrors->setText(0, 1, it.data().latin1());
	      }
	}
	
	if(wdf->exec()==QDialog::Accepted)
	{
	    wdd->setDisplayName(wdf->txtDisplayName->text());
	    wdd->setSessionTimeOut(wdf->sbSessionTimeout->value());
	    prs=wdf->tblParams->numRows();
	    wdd->getParameters()->clear(); 
	    for(int i=0; i< prs;i++)
		wdd->getParameters()->append(new CtxParameter(wdf->tblParams->text(i,0),wdf->tblParams->text(i,1),wdf->tblParams->text(i,2)));
	    
	    /****** Files Tab handler *******/
	wdd->setEnaWelcome(false);
	if(wdf->cbWelcome->isChecked())
	{
		//Welcome file list enabled
		prs=wdf->tblWelcome->numRows();
		for(int i=0; i< prs; i++)
		{
		    if(wdf->tblWelcome->text(i, 0).stripWhiteSpace()!="")
		    {
			wdd->setEnaWelcome(true);
			wdd->getWelcomeFiles()->append(wdf->tblWelcome->text(i, 0).stripWhiteSpace());
		    }
		}
	}
	wdd->setEnaErrorPages(false);
	if(wdf->cbErrors->isChecked())
	{
		//Errors file list enabled
		prs=wdf->tblErrors->numRows();
		for(int i=0; i< prs; i++)
		{
		    if(wdf->tblErrors->text(i, 0).stripWhiteSpace()!="")
		    {
			bool fl=true;
			wdf->tblErrors->text(i, 0).stripWhiteSpace().toInt(&fl);
			if(fl)
			{
			    wdd->setEnaErrorPages(true);
			    wdd->getErrorPages()->insert(wdf->tblErrors->text(i, 0).stripWhiteSpace(), wdf->tblErrors->text(i, 1).stripWhiteSpace());
			}
		    }
		}
	}

	} //Accepted
	delete wdf;
    }
}


CtxParameter* WebXml::readCtxParams( QDomNode node )
{
    //qDebug(node.nodeName()+":::");
    //qDebug(node.namedItem("param-name").firstChild().nodeValue());
    //qDebug(node.namedItem("param-value").firstChild().nodeValue());
   // qDebug(node.namedItem("description").firstChild().nodeValue());
    return new CtxParameter(node.namedItem("param-name").firstChild().nodeValue(), node.namedItem("param-value").firstChild().nodeValue(),node.namedItem("description").firstChild().nodeValue() );
}


int WebXml::readSessionTimeout( QDomNode node )
{
    if(node.namedItem("session-timeout").firstChild().nodeValue().toInt())
	return node.namedItem("session-timeout").firstChild().nodeValue().toInt();
    return 30;
}


void WebXml::readWelcomeFiles( QStringList *wfList, QDomNode node)
{
    QDomNodeList listWf=node.childNodes();
    for(int i=0; i<listWf.length();i++)
    {
	//qDebug("L808 "+listWf.item(i).nodeName()+" "+listWf.item(i).firstChild().nodeValue());
	if(listWf.item(i).nodeName().lower()=="welcome-file")
	{
	    wfList->append(listWf.item(i).firstChild().nodeValue());
	}
    }
}


void WebXml::readErrorPage( QMap<QString,QString>*map, QDomNode node )
{
    QString code=node.namedItem("error-code").firstChild().nodeValue();
    QString loc=node.namedItem("location").firstChild().nodeValue();
    map->insert(code, loc);
}


void WebXml::showPreview()
{
    frmPreview *pr=new frmPreview();
    QString str;
     QTextStream t( &str, IO_WriteOnly );
    t << "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" << "\n";
    t << "<!DOCTYPE web-app" << "\n";
    t << "PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"" << "\n";
    t << "\"http://java.sun.com/dtd/web-app_2_3.dtd\">" << "\n";
  
    t << doDoc() << "\n";
    
    pr->txtPreview->setText(str);
    if(pr->exec() == QDialog::Accepted)
    {
	filePrint();
    }
    delete pr;
}
