#!/usr/bin/python

REMOTE_LIST="http://weechat.org/files/plugins.xml"
MIN_VERSION="0.3.0"

import sys, os.path, urllib2
from xml.etree.cElementTree import fromstring as xmlParser

class WeechatScripts:

    def get_xmldom(self):
        xmldom = None
        try:
            fd = urllib2.urlopen(REMOTE_LIST)
            xmlstr = fd.read()
        except:
            xmlstr = None
            print "ERR: unable to retrieve '%s'" % (REMOTE_LIST)
        if xmlstr:
            try:
                xmldom = xmlParser(xmlstr)
            except:
                print "ERR: unable to parse XML"
                xmldom = None
        return xmldom

    def rw_license(self, license):
        licenses = {
            'GPL2': 'GPL-2',
            'GPL3': 'GPL-3',
            'Apache 2.0': 'Apache-2',
            'Public domain': 'public-domain',
        }
        if license in licenses.keys():
            license = licenses[license]
        return license

    def get_datas(self):
        scripts = {}
        licenses = []
        xmldom = self.get_xmldom()
        if xmldom:
            for el in xmldom.findall('plugin'):
                if el.find('min_weechat').text < MIN_VERSION:
                    continue

                lang = el.find('language').text
                filename = el.find('url').text.split('/')[-1]

                author = "%s <%s>" % (el.find('author').text, el.find('mail').text)
                #author = author.replace(' [at] ', '@')
                #author = author.replace(' [dot] ', '.')

                date = ''
                date_add = int(el.find('added').text.split('-')[0])
                if el.find('updated').text == None:
                   date = "%d" % (date_add)
                else:
                    date_upd = int(el.find('updated').text.split('-')[0])
                    if date_upd > date_add:
                        date = "%d-%d" % (date_add, date_upd)
                    else:
                        date = "%d" % (date_add)

                license = self.rw_license(el.find('license').text)
                if not license in licenses:
                    licenses.append(license)

                if not scripts.has_key(lang):
                    scripts[lang] = []
                scripts[lang].append({
                        'language': el.find('language').text,
                        'url': el.find('url').text,
                        'file': filename,
                        'version': el.find('version').text,
                        'license': license,
                        'author': author,
                        'date': date,
                        })
        return scripts, licenses

    def short_license(self, license):
        content = ''
        f = "%s/licenses/%s" % (os.path.dirname(__file__), license)
        if os.path.isfile(f):
            content = open(f).read()
        return content

    def copyright_header(self):
        content = ''
        f = "%s/copyright.in" % (os.path.dirname(__file__))
        if os.path.isfile(f):
            content = open(f).read()
        return content

    def copyright(self):
        scripts, licenses = self.get_datas()
        print self.copyright_header()
        if scripts != {}:
            for l in sorted(scripts.keys()):
                for script in scripts[l]:
                    print "Files: %s/%s" % (l.lower(), script['file'])
                    print "Copyright: %s, %s" % (script['date'], script['author'].encode('utf-8'))
                    print "License: %s" % (script['license'])
                    print
        if licenses != []:
            for license in sorted(licenses):
                print "License: %s" % (license)
                print self.short_license(license)

    def wget(self, url, path):
        ret = False
        content = None
        try:
            fd = urllib2.urlopen(url)
            content = fd.read()
        except:
            print "ERR: unable to retrieve '%s'" % (url)
            content = None

        if content:
            try:
                f = open(path, 'w')
                f.write(content)
                f.close()
                ret = True
            except:
                print "ERR: unable to write file '%s'" % (path)

        return ret

    def download(self):
        scriptlist, _ = self.get_datas()
        if scriptlist != {}:
            for l in scriptlist:
                for script in scriptlist[l]:
                    if not os.path.exists(script['language']):
                        os.mkdir(script['language'])
                    path = "%s/%s" % (script['language'], script['file'])
                    print "Saving '%s': " % (path),
                    if self.wget(script['url'], path):
                        print "OK"
                    else:
                        print "FAIL"


if __name__ == '__main__':
    args = ['copyright', 'download']
    if len(sys.argv) != 2:
        print "%s: %s" % (sys.argv[0], "|".join(args))
    elif sys.argv[1] not in args:
        print "%s: %s" % (sys.argv[0], "|".join(args))
    else:
        ws = WeechatScripts()
        if sys.argv[1] == 'copyright':
            ws.copyright()
        elif sys.argv[1] == 'download':
            ws.download()
