/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFLOGS_OBFUSCATOR_H
#define _WFLOGS_OBFUSCATOR_H

#include <string>
#include <iostream>
#include <map>

#include "wflogentry.h"

/**
 * 
 */
class wflogs_obfuscator {
 public:
  wflogs_obfuscator();
  virtual ~wflogs_obfuscator();
  // wflogs_obfuscator(const wflogs_obfuscator&) {} default copy constructor

  void reset();
  void setall();
  bool set(const string& criterias);
  void operator() (wf_logentry* entry);

  ostream& print(ostream& os) const;

 private:
  string changehostname(const string& hostname);
  unsigned int randomip(const wf_ipaddr& ipaddr);
  wf_macaddr changemacaddr(const wf_macaddr& macaddr);
  time_t changedate(time_t time);

 public:
  bool hostname;
  bool date;
  bool ipaddr;
  bool macaddr;
 private:
  map<string, u_int16_t> _hostnamecache;
  map<u_int32_t, u_int32_t> _ipcache;
  map<wf_macaddr, u_int32_t> _maccache;
  int _time_offset;
};

#endif
