import pygame
import os

from pygame.locals import *

from locals import *

import data

from tile import Tile
from animation import Animation

class Spikes(Tile):
  def __init__(self, screen, tilex, tiley, set = "brown"):
    Tile.__init__(self, screen, tilex, tiley, set, "spikes")
    self.itemclass = "spikes"
    self.realign()
    return

  def realign(self):
    self.rect.centery = self.y
    self.rect.centerx = self.x
    self.x = round(((self.rect.centerx)/TILE_DIM), 0)*TILE_DIM + self.rect.width / 2
    self.y = round((self.rect.bottom/TILE_DIM + 1), 0)*TILE_DIM - self.rect.height / 2
    return

