/*
 * NodeSuperExtrusion.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_SUPER_EXTRUSION_H
#define _NODE_SUPER_EXTRUSION_H

#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#include "NodeExtrusion.h"
#include "NodeNurbsCurve.h"

#include "SFMFTypes.h"

class Mesh;

class ProtoSuperExtrusion : public Proto {
public:
		    ProtoSuperExtrusion(Scene *scene);
    virtual Node   *create(Scene *scene);
    FieldIndex      a;
    FieldIndex      b;
    FieldIndex      m;
    FieldIndex      n1;
    FieldIndex      n2;
    FieldIndex      n3;
    FieldIndex      border;
    FieldIndex      creaseAngle;
    FieldIndex      superTessellation;
    FieldIndex      spineTessellation;
    FieldIndex      controlPoint;
    FieldIndex      weight;
    FieldIndex      knot;
    FieldIndex      order;
    FieldIndex      beginCap;
    FieldIndex      endCap;
    FieldIndex      solid;
    FieldIndex      scale;        
};

class NodeSuperExtrusion : public Node {
public:
		    NodeSuperExtrusion(Scene *scene, Proto *proto);
		    ~NodeSuperExtrusion();
    virtual int	    getType() const { return NODE_SUPER_EXTRUSION; }
    virtual Node   *copy() const { return new NodeSuperExtrusion(*this); }
    virtual int	    getNodeClass() const { return PARAMETRIC_GEOMETRY_NODE; }

    virtual void    draw();
    virtual void    drawHandles();

    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v);

    virtual void    setField(int index, FieldValue *value);

    virtual bool    hasBoundingBox(void) { return true; }
    virtual Vec3f   getMinBoundingBox(void);
    virtual Vec3f   getMaxBoundingBox(void);
    virtual void    flip(int index);

    virtual bool    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    void            update(void) { _extrusionDirty = true; }
    void            reInit(void) { _extrusion = NULL; _extrusionDirty = true; }

    virtual Node   *toExtrusion(void);
    virtual bool    canConvertToExtrusion(void) { return true; }

    virtual Node   *toNurbsCurve(void);

    fieldMacros(SFFloat, a,                 ProtoSuperExtrusion)
    fieldMacros(SFFloat, b,                 ProtoSuperExtrusion)
    fieldMacros(SFFloat, m,                 ProtoSuperExtrusion)
    fieldMacros(SFFloat, n1,                ProtoSuperExtrusion)
    fieldMacros(SFFloat, n2,                ProtoSuperExtrusion)
    fieldMacros(SFFloat, n3,                ProtoSuperExtrusion)
    fieldMacros(SFFloat, border,            ProtoSuperExtrusion)
    fieldMacros(SFFloat, creaseAngle,       ProtoSuperExtrusion)
    fieldMacros(SFInt32, superTessellation, ProtoSuperExtrusion)
    fieldMacros(SFInt32, spineTessellation, ProtoSuperExtrusion)
    fieldMacros(MFVec3f, controlPoint,      ProtoSuperExtrusion)
    fieldMacros(MFDouble,weight,            ProtoSuperExtrusion)
    fieldMacros(MFDouble,knot,              ProtoSuperExtrusion)
    fieldMacros(SFInt32, order,             ProtoSuperExtrusion)
    fieldMacros(SFBool,  beginCap,          ProtoSuperExtrusion)
    fieldMacros(SFBool,  endCap,            ProtoSuperExtrusion)
    fieldMacros(MFVec2f, scale,             ProtoSuperExtrusion)
protected:
    void	    createExtrusion();

    NodeExtrusion  *_extrusion;
    NodeNurbsCurve *_nurbsCurve;
    bool            _extrusionDirty;
    Array<float>    _chain;
};
#endif // _NODE_SUPER_EXTRUSION_H
