(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Import R_sqrt.
Require Import Rfunctions.
Require Import Rbasic_fun.
Require BuiltIn.
Require int.Int.
Require bool.Bool.
Require real.Real.
Require real.RealInfix.
Require real.Abs.
Require real.FromInt.
Require real.Square.
Require real.PowerInt.
Require floating_point.Rounding.
Require floating_point.SingleFormat.
Require floating_point.DoubleFormat.
Require floating_point.Single.
Require floating_point.Double.
Require Jessie_memory_model.

Axiom charP : Type.
Parameter charP_WhyType : WhyType charP.
Existing Instance charP_WhyType.

Axiom doubleP : Type.
Parameter doubleP_WhyType : WhyType doubleP.
Existing Instance doubleP_WhyType.

Axiom int32 : Type.
Parameter int32_WhyType : WhyType int32.
Existing Instance int32_WhyType.

Axiom int8 : Type.
Parameter int8_WhyType : WhyType int8.
Existing Instance int8_WhyType.

Axiom padding : Type.
Parameter padding_WhyType : WhyType padding.
Existing Instance padding_WhyType.

Axiom uint8 : Type.
Parameter uint8_WhyType : WhyType uint8.
Existing Instance uint8_WhyType.

Axiom unsigned_charP : Type.
Parameter unsigned_charP_WhyType : WhyType unsigned_charP.
Existing Instance unsigned_charP_WhyType.

Axiom voidP : Type.
Parameter voidP_WhyType : WhyType voidP.
Existing Instance voidP_WhyType.

(* Why3 assumption *)
Definition bounded (x_1:R) (k:R): Prop := ((-k)%R <= x_1)%R /\ (x_1 <= k)%R.

Parameter charP_tag: (Jessie_memory_model.tag_id charP).

Axiom charP_int : ((Jessie_memory_model.int_of_tag charP_tag) = 1%Z).

Parameter charP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer charP).

Axiom charP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  charP)),
  (p = (charP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom charP_parenttag_bottom : (Jessie_memory_model.parenttag charP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id charP))).

Axiom charP_tags : forall (x:(Jessie_memory_model.pointer charP)),
  forall (charP_tag_table:(Jessie_memory_model.tag_table charP)),
  (Jessie_memory_model.instanceof charP_tag_table x charP_tag).

(* Why3 assumption *)
Definition norm2 (p1:R) (p2:R) (p3:R) (p4:R): R :=
  ((((p1 * p1)%R + (p2 * p2)%R)%R + (p3 * p3)%R)%R + (p4 * p4)%R)%R.

(* Why3 assumption *)
Definition distance2 (p0:R) (p1_4:R) (p2_4:R) (p3_4:R) (q0:R) (q1_0:R)
  (q2_0:R) (q3:R): R := (norm2 (q0 - p0)%R (q1_0 - p1_4)%R (q2_0 - p2_4)%R
  (q3 - p3_4)%R).

(* Why3 assumption *)
Definition distanceQvect (q_1:(Jessie_memory_model.pointer doubleP)) (p0_1:R)
  (p1_6:R) (p2_6:R) (p3_6:R)
  (doubleP_doubleM_q_1_6_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): R :=
  (sqrt (distance2 (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_1_6_at_L
  (Jessie_memory_model.shift q_1 0%Z)))
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_1_6_at_L
  (Jessie_memory_model.shift q_1 1%Z)))
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_1_6_at_L
  (Jessie_memory_model.shift q_1 2%Z)))
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_1_6_at_L
  (Jessie_memory_model.shift q_1 3%Z))) p0_1 p1_6 p2_6 p3_6)).

Parameter doubleP_tag: (Jessie_memory_model.tag_id doubleP).

Axiom doubleP_int : ((Jessie_memory_model.int_of_tag doubleP_tag) = 1%Z).

Parameter doubleP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer doubleP).

Axiom doubleP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  doubleP)),
  (p = (doubleP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom doubleP_parenttag_bottom : (Jessie_memory_model.parenttag doubleP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id doubleP))).

Axiom doubleP_tags : forall (x:(Jessie_memory_model.pointer doubleP)),
  forall (doubleP_tag_table:(Jessie_memory_model.tag_table doubleP)),
  (Jessie_memory_model.instanceof doubleP_tag_table x doubleP_tag).

Parameter integer_of_int32: int32 -> Z.

(* Why3 assumption *)
Definition eq_int32 (x:int32) (y:int32): Prop :=
  ((integer_of_int32 x) = (integer_of_int32 y)).

Parameter integer_of_int8: int8 -> Z.

(* Why3 assumption *)
Definition eq_int8 (x:int8) (y:int8): Prop :=
  ((integer_of_int8 x) = (integer_of_int8 y)).

Parameter integer_of_uint8: uint8 -> Z.

(* Why3 assumption *)
Definition eq_uint8 (x:uint8) (y:uint8): Prop :=
  ((integer_of_uint8 x) = (integer_of_uint8 y)).

Parameter int32_of_integer: Z -> int32.

Axiom int32_coerce : forall (x:Z), (((-2147483648%Z)%Z <= x)%Z /\
  (x <= 2147483647%Z)%Z) -> ((integer_of_int32 (int32_of_integer x)) = x).

Axiom int32_extensionality : forall (x:int32), forall (y:int32),
  ((integer_of_int32 x) = (integer_of_int32 y)) -> (x = y).

Axiom int32_range : forall (x:int32),
  ((-2147483648%Z)%Z <= (integer_of_int32 x))%Z /\
  ((integer_of_int32 x) <= 2147483647%Z)%Z.

Parameter int8_of_integer: Z -> int8.

Axiom int8_coerce : forall (x:Z), (((-128%Z)%Z <= x)%Z /\ (x <= 127%Z)%Z) ->
  ((integer_of_int8 (int8_of_integer x)) = x).

Axiom int8_extensionality : forall (x:int8), forall (y:int8),
  ((integer_of_int8 x) = (integer_of_int8 y)) -> (x = y).

Axiom int8_range : forall (x:int8), ((-128%Z)%Z <= (integer_of_int8 x))%Z /\
  ((integer_of_int8 x) <= 127%Z)%Z.

(* Why3 assumption *)
Definition left_valid_struct_charP (p:(Jessie_memory_model.pointer charP))
  (a:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_doubleP (p:(Jessie_memory_model.pointer
  doubleP)) (a:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_voidP (p:(Jessie_memory_model.pointer voidP))
  (a:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition norm_vect (p1_2:R) (p2_2:R) (p3_2:R) (p4_2:R): R :=
  (sqrt (norm2 p1_2 p2_2 p3_2 p4_2)).

Axiom pointer_addr_of_charP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (charP_of_pointer_address p))).

Axiom pointer_addr_of_doubleP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (doubleP_of_pointer_address p))).

Parameter unsigned_charP_of_pointer_address: (Jessie_memory_model.pointer
  unit) -> (Jessie_memory_model.pointer unsigned_charP).

Axiom pointer_addr_of_unsigned_charP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (unsigned_charP_of_pointer_address p))).

Parameter voidP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer voidP).

Axiom pointer_addr_of_voidP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (voidP_of_pointer_address p))).

Parameter power: R -> Z -> R.

(* Why3 assumption *)
Definition product1 (usQ1:(Jessie_memory_model.pointer doubleP))
  (usQ2:(Jessie_memory_model.pointer doubleP))
  (doubleP_doubleM_Q2_8_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double))
  (doubleP_doubleM_Q1_7_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): R :=
  (((((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_7_at_L
  (Jessie_memory_model.shift usQ1
  0%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_8_at_L
  (Jessie_memory_model.shift usQ2
  0%Z))))%R - ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_7_at_L
  (Jessie_memory_model.shift usQ1
  1%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_8_at_L
  (Jessie_memory_model.shift usQ2
  1%Z))))%R)%R - ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_7_at_L
  (Jessie_memory_model.shift usQ1
  2%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_8_at_L
  (Jessie_memory_model.shift usQ2
  2%Z))))%R)%R - ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_7_at_L
  (Jessie_memory_model.shift usQ1
  3%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_8_at_L
  (Jessie_memory_model.shift usQ2 3%Z))))%R)%R.

(* Why3 assumption *)
Definition product2 (usQ1_0:(Jessie_memory_model.pointer doubleP))
  (usQ2_0:(Jessie_memory_model.pointer doubleP))
  (doubleP_doubleM_Q2_0_10_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double))
  (doubleP_doubleM_Q1_0_9_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): R :=
  (((((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_0_9_at_L
  (Jessie_memory_model.shift usQ1_0
  0%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_0_10_at_L
  (Jessie_memory_model.shift usQ2_0
  1%Z))))%R + ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_0_9_at_L
  (Jessie_memory_model.shift usQ1_0
  1%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_0_10_at_L
  (Jessie_memory_model.shift usQ2_0
  0%Z))))%R)%R + ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_0_9_at_L
  (Jessie_memory_model.shift usQ1_0
  2%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_0_10_at_L
  (Jessie_memory_model.shift usQ2_0
  3%Z))))%R)%R - ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_0_9_at_L
  (Jessie_memory_model.shift usQ1_0
  3%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_0_10_at_L
  (Jessie_memory_model.shift usQ2_0 2%Z))))%R)%R.

(* Why3 assumption *)
Definition product3 (usQ1_1:(Jessie_memory_model.pointer doubleP))
  (usQ2_1:(Jessie_memory_model.pointer doubleP))
  (doubleP_doubleM_Q2_1_12_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double))
  (doubleP_doubleM_Q1_1_11_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): R :=
  (((((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_1_11_at_L
  (Jessie_memory_model.shift usQ1_1
  0%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_1_12_at_L
  (Jessie_memory_model.shift usQ2_1
  2%Z))))%R - ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_1_11_at_L
  (Jessie_memory_model.shift usQ1_1
  1%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_1_12_at_L
  (Jessie_memory_model.shift usQ2_1
  3%Z))))%R)%R + ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_1_11_at_L
  (Jessie_memory_model.shift usQ1_1
  2%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_1_12_at_L
  (Jessie_memory_model.shift usQ2_1
  0%Z))))%R)%R + ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_1_11_at_L
  (Jessie_memory_model.shift usQ1_1
  3%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_1_12_at_L
  (Jessie_memory_model.shift usQ2_1 1%Z))))%R)%R.

(* Why3 assumption *)
Definition product4 (usQ1_2:(Jessie_memory_model.pointer doubleP))
  (usQ2_2:(Jessie_memory_model.pointer doubleP))
  (doubleP_doubleM_Q2_2_14_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double))
  (doubleP_doubleM_Q1_2_13_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): R :=
  (((((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_2_13_at_L
  (Jessie_memory_model.shift usQ1_2
  0%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_2_14_at_L
  (Jessie_memory_model.shift usQ2_2
  3%Z))))%R + ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_2_13_at_L
  (Jessie_memory_model.shift usQ1_2
  1%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_2_14_at_L
  (Jessie_memory_model.shift usQ2_2
  2%Z))))%R)%R - ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_2_13_at_L
  (Jessie_memory_model.shift usQ1_2
  2%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_2_14_at_L
  (Jessie_memory_model.shift usQ2_2
  1%Z))))%R)%R + ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q1_2_13_at_L
  (Jessie_memory_model.shift usQ1_2
  3%Z))) * (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_Q2_2_14_at_L
  (Jessie_memory_model.shift usQ2_2 0%Z))))%R)%R.

(* Why3 assumption *)
Definition quat_eq (q1:(Jessie_memory_model.pointer doubleP))
  (q2:(Jessie_memory_model.pointer doubleP))
  (doubleP_doubleM_q2_2_at_L2:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double))
  (doubleP_doubleM_q1_1_at_L1:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): Prop :=
  ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q1_1_at_L1
  (Jessie_memory_model.shift q1
  0%Z))) = (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q2_2_at_L2
  (Jessie_memory_model.shift q2 0%Z)))) /\
  (((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q1_1_at_L1
  (Jessie_memory_model.shift q1
  1%Z))) = (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q2_2_at_L2
  (Jessie_memory_model.shift q2 1%Z)))) /\
  (((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q1_1_at_L1
  (Jessie_memory_model.shift q1
  2%Z))) = (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q2_2_at_L2
  (Jessie_memory_model.shift q2 2%Z)))) /\
  ((floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q1_1_at_L1
  (Jessie_memory_model.shift q1
  3%Z))) = (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q2_2_at_L2
  (Jessie_memory_model.shift q2 3%Z)))))).

(* Why3 assumption *)
Definition quat_norm (q:(Jessie_memory_model.pointer doubleP))
  (doubleP_doubleM_q_5_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): R :=
  (norm_vect (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_5_at_L
  (Jessie_memory_model.shift q 0%Z)))
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_5_at_L
  (Jessie_memory_model.shift q 1%Z)))
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_5_at_L
  (Jessie_memory_model.shift q 2%Z)))
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_5_at_L
  (Jessie_memory_model.shift q 3%Z)))).

(* Why3 assumption *)
Definition right_valid_struct_charP (p:(Jessie_memory_model.pointer charP))
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_doubleP (p:(Jessie_memory_model.pointer
  doubleP)) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop :=
  (b <= (Jessie_memory_model.offset_max doubleP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  (b <= (Jessie_memory_model.offset_max unsigned_charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_voidP (p:(Jessie_memory_model.pointer voidP))
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

(* Why3 assumption *)
Definition strict_valid_root_charP (p:(Jessie_memory_model.pointer charP))
  (a:Z) (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table
  charP)): Prop := ((Jessie_memory_model.offset_min charP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_doubleP (p:(Jessie_memory_model.pointer
  doubleP)) (a:Z) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max doubleP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) = a) /\
  ((Jessie_memory_model.offset_max unsigned_charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_voidP (p:(Jessie_memory_model.pointer voidP))
  (a:Z) (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table
  voidP)): Prop := ((Jessie_memory_model.offset_min voidP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max voidP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_charP (p:(Jessie_memory_model.pointer charP))
  (a:Z) (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table
  charP)): Prop := ((Jessie_memory_model.offset_min charP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_doubleP (p:(Jessie_memory_model.pointer
  doubleP)) (a:Z) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max doubleP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) = a) /\
  ((Jessie_memory_model.offset_max unsigned_charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_voidP (p:(Jessie_memory_model.pointer voidP))
  (a:Z) (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table
  voidP)): Prop := ((Jessie_memory_model.offset_min voidP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max voidP_alloc_table p) = b).

Parameter uint8_of_integer: Z -> uint8.

Axiom uint8_coerce : forall (x:Z), ((0%Z <= x)%Z /\ (x <= 255%Z)%Z) ->
  ((integer_of_uint8 (uint8_of_integer x)) = x).

Axiom uint8_extensionality : forall (x:uint8), forall (y:uint8),
  ((integer_of_uint8 x) = (integer_of_uint8 y)) -> (x = y).

Axiom uint8_range : forall (x:uint8), (0%Z <= (integer_of_uint8 x))%Z /\
  ((integer_of_uint8 x) <= 255%Z)%Z.

Parameter unsigned_charP_tag: (Jessie_memory_model.tag_id unsigned_charP).

Axiom unsigned_charP_int : ((Jessie_memory_model.int_of_tag unsigned_charP_tag) = 1%Z).

Axiom unsigned_charP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  unsigned_charP)),
  (p = (unsigned_charP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom unsigned_charP_parenttag_bottom : (Jessie_memory_model.parenttag
  unsigned_charP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id
  unsigned_charP))).

Axiom unsigned_charP_tags : forall (x:(Jessie_memory_model.pointer
  unsigned_charP)),
  forall (unsigned_charP_tag_table:(Jessie_memory_model.tag_table
  unsigned_charP)), (Jessie_memory_model.instanceof unsigned_charP_tag_table
  x unsigned_charP_tag).

(* Why3 assumption *)
Definition valid_root_charP (p:(Jessie_memory_model.pointer charP)) (a:Z)
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_root_doubleP (p:(Jessie_memory_model.pointer doubleP)) (a:Z)
  (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) <= a)%Z /\ (b <= (Jessie_memory_model.offset_max doubleP_alloc_table
  p))%Z.

(* Why3 assumption *)
Definition valid_root_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max unsigned_charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_root_voidP (p:(Jessie_memory_model.pointer voidP)) (a:Z)
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_charP (p:(Jessie_memory_model.pointer charP)) (a:Z)
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_doubleP (p:(Jessie_memory_model.pointer doubleP))
  (a:Z) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) <= a)%Z /\ (b <= (Jessie_memory_model.offset_max doubleP_alloc_table
  p))%Z.

(* Why3 assumption *)
Definition valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max unsigned_charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_voidP (p:(Jessie_memory_model.pointer voidP)) (a:Z)
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

Parameter voidP_tag: (Jessie_memory_model.tag_id voidP).

Axiom voidP_int : ((Jessie_memory_model.int_of_tag voidP_tag) = 1%Z).

Axiom voidP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  voidP)),
  (p = (voidP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom voidP_parenttag_bottom : (Jessie_memory_model.parenttag voidP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id voidP))).

Axiom voidP_tags : forall (x:(Jessie_memory_model.pointer voidP)),
  forall (voidP_tag_table:(Jessie_memory_model.tag_table voidP)),
  (Jessie_memory_model.instanceof voidP_tag_table x voidP_tag).

Axiom norm2_pos : forall (p1_0:R), forall (p2_0:R), forall (p3_0:R),
  forall (p4_0:R), (0%R <= (norm2 p1_0 p2_0 p3_0 p4_0))%R.

Axiom norm2_neg : forall (p1_1:R), forall (p2_1:R), forall (p3_1:R),
  forall (p4_1:R), ((norm2 (-p1_1)%R (-p2_1)%R (-p3_1)%R
  (-p4_1)%R) = (norm2 p1_1 p2_1 p3_1 p4_1)).

Axiom norm_vect_pos : forall (p1_3:R), forall (p2_3:R), forall (p3_3:R),
  forall (p4_3:R), (0%R <= (norm_vect p1_3 p2_3 p3_3 p4_3))%R.

Axiom quat_norm_pos : forall (doubleP_doubleM_q_0_19_at_L:(Jessie_memory_model.memory
  doubleP floating_point.DoubleFormat.double)),
  forall (q_0_1:(Jessie_memory_model.pointer doubleP)),
  (0%R <= (quat_norm q_0_1 doubleP_doubleM_q_0_19_at_L))%R.

Axiom distance2_sym : forall (p0_0:R), forall (p1_5:R), forall (p2_5:R),
  forall (p3_5:R), forall (q0_0:R), forall (q1_1_0:R), forall (q2_1_0:R),
  forall (q3_0:R), ((norm2 (q0_0 - p0_0)%R (q1_1_0 - p1_5)%R
  (q2_1_0 - p2_5)%R (q3_0 - p3_5)%R) = (norm2 (p0_0 - q0_0)%R
  (p1_5 - q1_1_0)%R (p2_5 - q2_1_0)%R (p3_5 - q3_0)%R)).

Axiom sqr_pos : forall (x_0_0:R), forall (y:R), (0%R <= y)%R ->
  (0%R <= (y + (x_0_0 * x_0_0)%R)%R)%R.

Axiom norm_product : forall (doubleP_doubleM_q2_2_21_at_L:(Jessie_memory_model.memory
  doubleP floating_point.DoubleFormat.double)),
  forall (doubleP_doubleM_q1_2_20_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)),
  forall (q1_2:(Jessie_memory_model.pointer doubleP)),
  forall (q2_2:(Jessie_memory_model.pointer doubleP)),
  ((norm_vect (product1 q1_2 q2_2 doubleP_doubleM_q2_2_21_at_L
  doubleP_doubleM_q1_2_20_at_L) (product2 q1_2 q2_2
  doubleP_doubleM_q2_2_21_at_L doubleP_doubleM_q1_2_20_at_L) (product3 q1_2
  q2_2 doubleP_doubleM_q2_2_21_at_L doubleP_doubleM_q1_2_20_at_L)
  (product4 q1_2 q2_2 doubleP_doubleM_q2_2_21_at_L
  doubleP_doubleM_q1_2_20_at_L)) = ((quat_norm q1_2
  doubleP_doubleM_q1_2_20_at_L) * (quat_norm q2_2
  doubleP_doubleM_q2_2_21_at_L))%R).

Axiom bounded_sqr : forall (x_2:R), forall (k_0:R), ((0%R <= k_0)%R /\
  ((x_2 * x_2)%R <= (k_0 * k_0)%R)%R) -> (bounded x_2 k_0).

Axiom bounded_norm_aux : forall (p1_8:R), forall (p2_8:R), forall (p3_8:R),
  forall (p4_5:R), forall (k_1:R), ((0%R <= k_1)%R /\ ((norm2 p1_8 p2_8 p3_8
  p4_5) <= (k_1 * k_1)%R)%R) -> ((bounded p1_8 k_1) /\ ((bounded p2_8 k_1) /\
  ((bounded p3_8 k_1) /\ (bounded p4_5 k_1)))).

Axiom sqrt_le_le_sqr : forall (x_3:R), forall (y_0:R), ((0%R <= x_3)%R /\
  ((sqrt x_3) <= y_0)%R) -> (x_3 <= (y_0 * y_0)%R)%R.

Axiom bounded_norm_aux2 : forall (p1_9:R), forall (p2_9:R), forall (p3_9:R),
  forall (p4_6:R), forall (k_2:R), ((0%R <= k_2)%R /\ ((norm_vect p1_9 p2_9
  p3_9 p4_6) <= k_2)%R) -> ((bounded p1_9 k_2) /\ ((bounded p2_9 k_2) /\
  ((bounded p3_9 k_2) /\ (bounded p4_6 k_2)))).

Axiom bounded_norm : forall (doubleP_doubleM_q_2_22_at_L:(Jessie_memory_model.memory
  doubleP floating_point.DoubleFormat.double)),
  forall (q_2:(Jessie_memory_model.pointer doubleP)), forall (k_3:R),
  ((quat_norm q_2 doubleP_doubleM_q_2_22_at_L) <= k_3)%R -> ((bounded
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_2_22_at_L
  (Jessie_memory_model.shift q_2 0%Z))) k_3) /\ ((bounded
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_2_22_at_L
  (Jessie_memory_model.shift q_2 1%Z))) k_3) /\ ((bounded
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_2_22_at_L
  (Jessie_memory_model.shift q_2 2%Z))) k_3) /\ (bounded
  (floating_point.Double.value (Jessie_memory_model.select doubleP_doubleM_q_2_22_at_L
  (Jessie_memory_model.shift q_2 3%Z))) k_3)))).

Axiom pow_eps2_max_int : ((powerRZ (1%R + ((7 / 1125899906842624)%R + (3 / 9007199254740992)%R)%R)%R 2147483647%Z) <= 2%R)%R.

Axiom power_monotonic : forall (n_0:Z), forall (m:Z), forall (x_4:R),
  ((0%Z <= n_0)%Z /\ ((n_0 <= m)%Z /\ (1%R <= x_4)%R)) ->
  ((powerRZ x_4 n_0) <= (powerRZ x_4 m))%R.

Axiom pow_eps2_min : forall (n_1:Z), (0%Z <= n_1)%Z ->
  (1%R <= (powerRZ (1%R + ((7 / 1125899906842624)%R + (3 / 9007199254740992)%R)%R)%R n_1))%R.

Axiom pow_eps2_max : forall (n_2:Z), ((0%Z <= n_2)%Z /\
  (n_2 <= 2147483647%Z)%Z) ->
  ((powerRZ (1%R + ((7 / 1125899906842624)%R + (3 / 9007199254740992)%R)%R)%R n_2) <= 2%R)%R.

Axiom triangle_inequality : forall (p1_10:R), forall (p2_10:R),
  forall (p3_10:R), forall (p4_7:R), forall (q1_3:R), forall (q2_3:R),
  forall (q3_1:R), forall (q4:R), ((norm_vect (p1_10 + q1_3)%R
  (p2_10 + q2_3)%R (p3_10 + q3_1)%R (p4_7 + q4)%R) <= ((norm_vect p1_10 p2_10
  p3_10 p4_7) + (norm_vect q1_3 q2_3 q3_1 q4))%R)%R.

Require Import Why3.
Ltac ae := why3 "alt-ergo" timelimit 3.

(* Why3 goal *)
Theorem norm_distance_aux : forall (p1_11:R), forall (p2_11:R),
  forall (p3_11:R), forall (p4_8:R), forall (q1_4:R), forall (q2_4:R),
  forall (q3_2:R), forall (q4_0:R), ((sqrt (norm2 p1_11 p2_11 p3_11
  p4_8)) <= ((sqrt (distance2 p1_11 p2_11 p3_11 p4_8 q1_4 q2_4 q3_2
  q4_0)) + (sqrt (norm2 q1_4 q2_4 q3_2 q4_0)))%R)%R.
(* intros p1_11 p2_11 p3_11 p4_8 q1_4 q2_4 q3_2 q4_0. *)
intros p1 p2 p3 p4 q1 q2 q3 q4.
generalize (triangle_inequality 
  (p1 - q1) (p2 - q2) (p3 - q3) (p4 - q4) q1 q2 q3 q4).
intro H.
unfold norm_vect in H.
unfold distance2.
rewrite distance2_sym.
ae.
Qed.


