(********************************************************************)
(*                                                                  *)
(*  The Why3 Verification Platform   /   The Why3 Development Team  *)
(*  Copyright 2010-2016   --   INRIA - CNRS - Paris-Sud University  *)
(*                                                                  *)
(*  This software is distributed under the terms of the GNU Lesser  *)
(*  General Public License version 2.1, with the special exception  *)
(*  on linking described in file LICENSE.                           *)
(*                                                                  *)
(********************************************************************)

(* This file is generated by Why3's Coq-realize driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Reals.Rtrigo_def.
Require Reals.Rpower.
Require Reals.R_sqrt.
Require BuiltIn.
Require real.Real.
Require real.Square.
Require real.ExpLog.

Import Rpower.

(* Why3 goal *)
Definition pow: R -> R -> R.
exact Rpower.
Defined.

(* Why3 goal *)
Lemma Pow_def : forall (x:R) (y:R), (0%R < x)%R -> ((pow x
  y) = (Reals.Rtrigo_def.exp (y * (Reals.Rpower.ln x))%R)).
intros x y h1.
now unfold pow.
Qed.

(* Why3 goal *)
Lemma Pow_pos : forall (x:R) (y:R), (0%R < x)%R -> (0%R < (pow x y))%R.
intros x y h1.
unfold pow, Rpower.
apply Exp_prop.exp_pos.
Qed.

(* Why3 goal *)
Lemma Pow_plus : forall (x:R) (y:R) (z:R), (0%R < z)%R -> ((pow z
  (x + y)%R) = ((pow z x) * (pow z y))%R).
intros x y z h1.
now apply Rpower_plus.
Qed.

(* Why3 goal *)
Lemma Pow_mult : forall (x:R) (y:R) (z:R), (0%R < x)%R -> ((pow (pow x y)
  z) = (pow x (y * z)%R)).
intros x y z h1.
now apply Rpower_mult.
Qed.

(* Why3 goal *)
Lemma Pow_x_zero : forall (x:R), (0%R < x)%R -> ((pow x 0%R) = 1%R).
intros x h1.
now apply Rpower_O.
Qed.

(* Why3 goal *)
Lemma Pow_x_one : forall (x:R), (0%R < x)%R -> ((pow x 1%R) = x).
intros x h1.
now apply Rpower_1.
Qed.

(* Why3 goal *)
Lemma Pow_one_y : forall (y:R), ((pow 1%R y) = 1%R).
intros y.
unfold pow, Rpower.
rewrite ln_1.
rewrite Rmult_0_r.
now apply  Rtrigo_def.exp_0.
Qed.

(* Why3 goal *)
Lemma Pow_x_two : forall (x:R), (0%R < x)%R -> ((pow x
  2%R) = (Reals.RIneq.Rsqr x)).
intros x h1.
rewrite Rpower_plus.
rewrite Rpower_1; auto.
Qed.

(* Why3 goal *)
Lemma Pow_half : forall (x:R), (0%R < x)%R -> ((pow x
  (05 / 10)%R) = (Reals.R_sqrt.sqrt x)).
intros x h1.
replace (5 / 10)%R with (/ 2)%R by field.
now apply Rpower_sqrt.
Qed.

