/*
 * Copyright (C) 2002-2004, 2006-2008 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef IDLEWORKERSUPPLY_H
#define IDLEWORKERSUPPLY_H

#include "transport.h"

namespace Widelands {

struct IdleWorkerSupply : public Supply {
	IdleWorkerSupply(Worker *);
	~IdleWorkerSupply();

	void set_economy(Economy *);
	virtual PlayerImmovable * get_position(Game *);

	/// Idle workers are always active supplies, because they need to get
	/// into a Warehouse ASAP.
	virtual bool is_active() const throw () {return true;}

	virtual uint32_t nr_supplies(Game *, Request const *) const;
	virtual WareInstance & launch_item(Game *, const Request*)
		__attribute__ ((noreturn));
	virtual Worker * launch_worker(Game *, const Request*);

private:
	Worker  * m_worker;
	Economy * m_economy;
};

};

#endif
