/*
 * Copyright (C) 2002-2004, 2006-2007 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "event_conquer_area.h"
#include "game.h"
#include "map.h"

Event::State Event_Conquer_Area::run(Game* game) {
	assert(m_player_area.is_valid());
	assert(0 < m_player_area.player_number);
	assert    (m_player_area.player_number <= game->map().get_nrplayers());

	game->conquer_area_no_building(m_player_area);

   m_state = DONE;
   return m_state;
}
