//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCPULLDOWNMENU_H
#define WSCPULLDOWNMENU_H

#include <WScom.h>
#include <WSCvlabel.h>
#include <WSDkeyboard.h>
class WSCpulldownMenuPopup;

#define WSCpulldownMenu_VER  1030

class WSCpulldownMenu  :public WSCvlabel{

  protected:
    WSCpulldownMenuPopup* _menu;
    short     _mouse_x;
    short     _mouse_y;
    char*     _menu_str;
    char*     _sc_str;
    char*     _ld_name;
    char*     _rd_name;
    unsigned  _press_state:1;
    unsigned  _grabed:1;
    unsigned  _mouse_no_check:1;


    WSMFpropertyDef(WSNleftward,  char*, _ld_name);
    WSMFpropertyDef(WSNrightward, char*, _rd_name);
    WSMFpropertyDef( WSNshortcut,  char*,  _sc_str); 
    WSMFpropertyDef( WSNmenuItems,  char*,  _menu_str); 
    //menu string= string:op name:shortcut key:value,
    //             string:op name:shortcut key:value,
    //             string:{
    //               string:op name:shortcut key:value,
    //               string:op name:shortcut key:value,
    //             },...

    virtual void setWorkWSNemboss(WSCbool);
    virtual void setWorkWSNshadowThickness(WSCuchar);

    virtual long _device_initialize();
    void _menu_popup(WSCpoint*);
    void _menu_popdown();
    void _menu_update();

    static WSCpulldownMenu* _ptarget;
    static void _key_handler(void*,WSDkeyboard*,WSCbool);
    WSCstring _get_proc_name_by_sc(char*,char*);

  public:
    WSCpulldownMenu(WSCbase*,char*);
    virtual ~WSCpulldownMenu();

    virtual void onMousePress(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onVisibleChange(WSCbool fl);
    virtual void onParentVisibleChange(WSCbool fl);
    virtual void onActivate();

    virtual long execEventProc(long ev,void*);
    virtual long initialize();
    virtual long draw();
    virtual long addProcedure(WSCprocedure*);

    long setItemSensitive(short no,WSCbool flag);
    long setValueSensitive(short id,WSCbool flag);

    WSCbool* getItemSensitive();

    long getValue();
    long getItems();

    long beginCascade(char* lb);
    long addItem(char* lb,char* op,char* shortc,long id);
    long endCascade();

    WSMFguiClassDef(WSCpulldownMenu,WSCvlabel);
    WSMFversionDef(WSCpulldownMenu);
};
#endif
