//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvcsocket.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvcsocket, WSCngbase);
WSMFversion(WSCvcsocket, WSCngbase);

WSCvcsocket::WSCvcsocket(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _socket = NULL;
  _addr = WSGFstrdup("");
  _port = 9000;
  _title_string.setString("Client\nSocket");
  _timeout = 60;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvcsocket);

    WSMFpropertyCreate(WSNip,      char*,   _addr,WSSip);
    WSMFpropertyCreate(WSNport,    WSCushort,   _port,WSSport);
    WSMFpropertyCreate(WSNtimeout, WSCulong,   _timeout,WSStimeout);

    WSMFaddTrigger(WSEV_ACTIVATE  );
  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvcsocket, WSNip, char*, _addr ,WSGFstrdup(""));
WSMFproperty( WSCvcsocket, WSNport, WSCushort, _port ,9000);
WSMFproperty( WSCvcsocket, WSNtimeout, WSCulong, _timeout ,60);

void WSCvcsocket::setWorkWSNip(char* ip){
  if (_socket == NULL){
    _socket = WSDsocket::getNewInstance();
  }
  _socket->setDestAddr(ip); 
};
void WSCvcsocket::getWorkWSNip(char**){};

void WSCvcsocket::setWorkWSNport(WSCushort port){
  if (_socket == NULL){
    _socket = WSDsocket::getNewInstance();
  }
  _socket->setDestPort(port); 
};
void WSCvcsocket::getWorkWSNport(WSCushort*){};

void WSCvcsocket::setWorkWSNtimeout(WSCulong timeout){
  if (_socket == NULL){
    _socket = WSDsocket::getNewInstance();
  }
  _socket->setTimeout(timeout); 
};
void WSCvcsocket::getWorkWSNtimeout(WSCulong*){};


void WSCvcsocket::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}

WSCvcsocket::~WSCvcsocket() {
  if (_socket != NULL){
    delete _socket;
    _socket = NULL;
  }
  if (_addr != NULL){
    delete _addr;
    _addr = NULL;
  }
}
void WSCvcsocket::_init(){
  if (_socket == NULL){
    _socket = WSDsocket::getNewInstance();
  }
  if (_socket == NULL){
    return;
  }
  _socket->setDestAddr(_addr); 
  _socket->setDestPort(_port); 
  _socket->setTimeout(_timeout); 
}
long WSCvcsocket::exec(){
  if (_socket == NULL){
    _init();
  }
  if (_socket == NULL){
    return WS_ERR;
  }
  if (strcmp(_bind_addr,"")){
    _socket->setAddr(_bind_addr); 
  }
  _socket->setDestAddr(_addr); 
  _socket->setDestPort(_port); 
  _socket->setTimeout(_timeout); 

  long ret = _socket->connect();
  if (ret != WS_NO_ERR){
    _error_str = _socket->getLastError();
    return WS_ERR;
  }
  onActivate();
  _socket->close();
  return WS_NO_ERR;
}

long WSCvcsocket::read(WSCuchar* buffer,long size){
  if (_socket == NULL){
    return -1;
  }
  long ret = _socket->read(buffer,size);
  _error_str = _socket->getLastError();
  return ret;
}
long WSCvcsocket::write(WSCuchar* buffer,long size){
  if (_socket == NULL){
    return -1;
  }
  long ret = _socket->write(buffer,size);
  _error_str = _socket->getLastError();
  return ret;
}
WSDsocket* WSCvcsocket::getSocket(){
  return _socket;
}
void WSCvcsocket::setBindAddr(char* addr){
  _bind_addr = addr;
}
WSCstring WSCvcsocket::getBindAddr(){
  return _bind_addr;
}
void WSCvcsocket::getErrorMsg(char* buffer,long size){
  if (size < 1){
    return;
  }
  strncpy(buffer,(char*)_error_str,size);
  buffer[size-1] = 0;
}
WSCstring WSCvcsocket::getErrorMessage(){
  WSCstring ret;
  ret.setString(_error_str);
  return ret;
}


