/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  jrlcode.cpp    9/17/98                                                 */
/*  Copyright (C) 1995 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include    <iomanip.h>
#include    <iostream.h>
#include    <fstream.h>
#include    "jrlcode.h"
#ifdef WS
#include <string.h>
#include <WSCstring.h>
#include <WScom.h>
#endif //WS

void cCode::clear_code()
{
    endpos = 0;
    for(int i=0;i<codeSize;i++) code[i]=0;
}

int cCode::LoadObjFile(char *FileName)
{
dbprintf("cCode::LoadObjFile %s:%d start FileName=%s\n",__FILE__,__LINE__,FileName);
    if (strlen(FileName) == 0) {
        long n;
        while(cin >> hex >> n){
dbprintf("cCode::LoadObjFile %s:%d endpos=%d n=%d\n",__FILE__,__LINE__,endpos,n);
          set_code(n);
        }
    } else {
#if 0
        ifstream source(FileName,ios::in);
dbprintf("cCode::LoadObjFile %s:%d done0 source=%d\n",__FILE__,__LINE__,source);

        if (!source) {
           cerr << "Cannot open source file " << FileName << " for input\n";
dbprintf("cCode::LoadObjFile %s:%d done0 endpos=%d\n",__FILE__,__LINE__,endpos);
           return 1;
        }

        long n;
        while(source >> hex >> n){
dbprintf("cCode::LoadObjFile %s:%d endpos=%d n=%d\n",__FILE__,__LINE__,endpos,n);
          set_code(n);
        }
        source.close();
#endif
        WSCstring* str = WSGFreadTextFile(FileName);
        if (str == NULL){
          return 1;
        }
        while(str->eof() == False){
          WSCstring line = str->gets();
          long val;
          sscanf(line.getString(),"%x",&val);
          set_code(val);
        }
        delete str;
    }
    if (endpos){
dbprintf("cCode::LoadObjFile %s:%d done1 endpos=%d\n",__FILE__,__LINE__,endpos);
      return 0;
    }else{
dbprintf("cCode::LoadObjFile %s:%d done2 endpos=%d\n",__FILE__,__LINE__,endpos);
      return 1;
    }
}

int cCode::SaveObjFile(char *FileName)
{
    if (strlen(FileName) == 0) {
        for(int i=0; i<endpos; i++)
        cout << hex << code[i] << '\n';
    } else {
        ofstream dest;
        dest.open(FileName);

        if (!dest) {
           cerr << "Cannot open destination file " << FileName << " for output\n";
           return 1;
        }

        for(int i=0; i<endpos; i++)
          dest << hex << (unsigned long)code[i] << '\n';
        dest.close();
    }
    return 0;
}

