/*-------------------------------------------------------------------------*/
/*  J3W ver 6.43  3D Animation Kit                                         */
/*  tpolygon.cpp   4/ 8/2001                                               */
/*  Copyright (C) 1996 - 2001 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include  "tpolygon.h"

TPolygons::TPolygons(int vn, int pn):Vertex(vn)
{
    Max = pn;
    pg = new Polygon3D*[pn];
    for(int i=0; i<pn; i++) pg[i] = 0;
    reflection = 1.0;
    ambient    = 0.25;
    off_center = 0;

    Count = 0;
}

TPolygons::~TPolygons()
{
    for(int i=0; i<Count; i++)
      if (pg[i] != 0) {
          delete pg[i]->index;
          delete pg[i];
      }
    delete pg;
}

void TPolygons::Add(int n, int color, const int *idx)
{
    int vc = Vertex.GetCount();
    int vo = Vertex.GetOffset();
    int verr = 0;

    for(int i=0; i<n; i++)
        if (vc <= idx[i] + vo) verr = 1;

    if ((Count < Max) && (!verr)) {
        pg[Count] = new Polygon3D;
        pg[Count]->color = color;
        pg[Count]->reflection = reflection;
        pg[Count]->ambient = ambient;
        pg[Count]->off_center = off_center;
        pg[Count]->n = n;
        pg[Count]->index = new int[n];

        for(int i=0; i<n; i++)
            pg[Count]->index[i] = idx[i] + Vertex.GetOffset();
        Count++;
    }
}

void TPolygons::SetPoly(int pos, int color, const int *idx)
{
    if (pos < Count) {
        int n = pg[pos]->n;
        pg[pos]->color = color;
        for(int i=0; i<n; i++) pg[pos]->index[i] = idx[i];
    }
}

void TPolygons::GetPoly(int pos, int &color, int *idx)
{
    if (pos < Count) {
        int n = pg[pos]->n;
        color = pg[pos]->color;
        for(int i=0; i<n; i++) idx[i] = pg[pos]->index[i];
    }
}

int TPolygons::GetVertexCount(int pos)
{
    if (pos < Count) return pg[pos]->n;
    else return -1;
}

