#ifndef CHEMEQ_H
#define CHEMEQ_H

#include <string.h>
#include <stdiostream.h>
#include <vector>
#include <string>
#include <map>

typedef struct {
  int Zed;
  char symb[4];
} atome;

extern atome lesatomes[];

typedef pair<string,int> AtomeCompte;

class Compteur : public map<string,float>{
public:
  ostream & operator << (ostream & o)const;
};

ostream & operator << (ostream & o, const Compteur & c);

class Chemeq;

class fraction{
public:
  int i;
  int d;
  fraction(int numerateur, int denominateur=1):i(numerateur),d(denominateur){};
  void inverse(){int n=i; i=d; d=n;};
  void simplifie();
};

ostream & operator << (ostream & o, fraction f);

fraction operator * (fraction f, int m);
fraction operator * (int m, fraction f);
fraction operator * (fraction f, fraction m);
fraction operator + (fraction f, fraction g);

bool operator > (fraction f, int i);
bool operator != (fraction f, int i);

class AtomeListe{
  AtomeListe * suiv, *group;
  char symb[4];
  int Zed, nb, no, sqbr;

 public:
  AtomeListe(const char* nom, int num, AtomeListe * s=0, AtomeListe * g=0){
    strncpy(symb,nom,3); Zed=num; nb=1; sqbr=0;
    /* sqbr == 1 quand il y a un square bracket */
    suiv = s; group=g;
  };
  AtomeListe(const AtomeListe & a):
    suiv(a.suiv), group(a.group), Zed(a.Zed), nb(a.nb), sqbr(a.sqbr){
    strncpy(symb,a.symb,3);
  };
  const char * symbole() const{return symb;};
  int Z()const{return Zed;};
  int sq()const{return sqbr;};
  void sq(int val){sqbr=val;};
  void numerote(int n=0);
  void setmolecularite(int n){nb=n;};
  int getmolecularite()const{return nb;};
  AtomeListe * groupe(){return group;};
  void groupe(AtomeListe * al){group= al;};
  const AtomeListe * suivant()const{return suiv;};
  const AtomeListe * groupe()const{return group;};
  void setsuivant(AtomeListe * s){suiv=s;};
  void compte (Compteur &c, fraction mult=fraction(1,1))const;
  static AtomeListe * triage(AtomeListe * al);
  void printnorm(ostream & o);
  void debug(int decal = 0)const{
    for (int i=0; i< decal; i++) cout << " ";
    cout << "AtomeListe : ( & = " << this << " symb=\"" << symb << "\" Zed = " << Zed 
	 << " nb = " << nb << " no = " << no 
	 << " suiv = " << suiv << " group = " << group
	 << ")\n";
    if(group) group->debug(2+decal);
    if(suiv) suiv->debug(decal);
  };
};

typedef enum { aqueous, gas, sol } moltype;

extern char* moltypeStr[]; /* les chanes aq, g,s */

class Molec{
  AtomeListe * al;
  int ch;
  fraction nb;
  int no;
  moltype t;
 public:
  Molec(AtomeListe * a, int c = 0, int n=1, int d=1): 
    al(a), ch(c), nb(n,d), t(aqueous){};
  AtomeListe & liste()const{return *al;};
  int charge()const{return ch;};
  void nombre(int n, int d=1){nb=fraction(n,d);};
  fraction nombre()const{return nb;};
  moltype typage()const{return t;};
  void typage(moltype at){t=at;};
  void numero(int n){no=n;};
  int numero()const{return no;};
  void triage(){al = AtomeListe::triage(al);};
  void compte(Compteur & c)const{if (al) al->compte(c,nb);};
  const string signature()const;
  void printNombre(ostream & o)const;
  void printnorm(ostream & o);
  void coeff( fraction f);
  bool printNernst(ostream & o, char * prefix ="");
  bool iswater()const;
  bool iselectron()const;
  fraction  nbelectron()const;
  void debug(int decal = 0)const{
    for (int i=0; i < decal; i++) cout << " ";
    cout << "Molec : ( " << this << " charge = " << ch 
	 << " nombre = " << nb << " no = " << no;
    al->debug(decal+2);
    cout << ")\n";
  };
};

ostream & operator << (ostream & o, const AtomeListe & l);
ostream & operator << (ostream & o, const Molec & m);

class Membre : public vector<Molec *>{
public:
  void compte(Compteur & c)const;
  void numerote();
  void triage();
  void printnorm(ostream & o);
  void coeff( fraction f);
  void printNernst(ostream & o);
  int printableNernst();
  bool redox()const;
  fraction  nbelectron()const;
  void debug(int decal = 0)const{
    for (int i=0; i < decal; i++) cout << " ";
    cout << "Membre : ( " << this;
    for (int j=0; j < size(); j++){
      cout << j << " :\n";
      operator[](j)->debug(decal+2);
    }
    cout << "\n";
  }
};

ostream & operator << (ostream & o, const Membre & m);

class Chemeq{
  Membre * gauche, * droit;
  string cste;
  double val;
public:
  Chemeq(Membre * g, Membre * d) : gauche (g), droit(d){};
  const Membre * membredroit()const{return droit;};
  const Membre * membregauche()const{return gauche;};
  void numerote(){gauche->numerote(); droit->numerote();};
  void triage(){gauche->triage(); droit->triage();};
  /* ajuste le coefficient pour qu'il y ait 1 mol du premier ractif */
  void coeff1();
  void normalise(){numerote(); triage(); coeff1();};
  void printnorm(ostream & o);
  void printNernst(ostream & o);
  string equilibre();
  bool redox()const;
  const string constante()const{ return cste;};
  void constante (const string s) { cste = s;};
  double valeur()const{return val;};
  void valeur(double r){val=r;};
};

ostream & operator << (ostream & o, const Chemeq & c);

#endif CHEMEQ_H
