%option noyywrap
%option c++
     
   #include <stdlib.h>
   #include "chemeq.h"

   char * ind;
   int position = 0;
     

/* les nombres */
digits         [0-9]
spc            [ \t]+
int            {digits}+
frac           {int}{spc}?[/]{spc}?{int}
mantisse       {digits}+
real           {int}([.]{mantisse})?([Ee][+-]?{int})?
eol            \n.*

/* la flche */
fleche         [-]+>

%%
 /* les rgles */

 /* pour les atomes */
Uu[a-z]|[A-Z][a-z]? { /* lments Uux : transuraniens aprs le N 109
                           les autres sont les lments ordinaires */
    int i = 0;
    position += strlen(yytext);
    while (lesatomes[i].Zed != 0 && strcmp(yytext, lesatomes[i].symb)) i++;
    if (lesatomes[i].Zed == 0){
      yylval.i=-2;      /* -2 est le n pour les lments non dfinis */
      strncpy(yylval.symb, yytext,3);
    }
    else {
      yylval.i=i;
      strcpy(yylval.symb, lesatomes[i].symb);
    }
    yylval.s = yytext;
    return Atome;
  }

e      {position++; yylval.i=-1; strcpy(yylval.symb, "e");return Atome;}


\(     { position++; return Lpar;}
\)     { position++; return Rpar;}

{spc}+\( { position += strlen(yytext); return SpcLpar;}
\[       { position ++; return Lsq;}
\]       { position ++; return Rsq;}
{int}  { position += strlen(yytext); yylval.i = atoi(yytext); return Int; }
{real} { position += strlen(yytext); yylval.r = atof(yytext); return Real;}
{frac} { position += strlen(yytext); ind = index(yytext,'/'); *ind=0; 
         yylval.i = atoi(yytext); yylval.d = atoi(ind+1); 
         return Frac;
       }
\+{int}  { position += strlen(yytext); yylval.i = atoi(yytext+1); 
           return Charge;
         }
\+[\+]+  { position += strlen(yytext); 
           yylval.i = strlen(yytext); return Charge;
         }
\-[\-]+  { position += strlen(yytext); yylval.i = -strlen(yytext); 
           return Charge;
         }
{int}\+  { position += strlen(yytext); yytext[strlen(yytext)]=0; 
           yylval.i = atoi(yytext); return Charge;
         }
\-{int}  { position += strlen(yytext); yylval.i = -atoi(yytext+1); 
           return Charge;
         }
{int}\-  { position += strlen(yytext); yytext[strlen(yytext)]=0; 
           yylval.i = -atoi(yytext); return Charge;
         }
{spc}+\+ {position += strlen(yytext); return SpcPlus;}
\-     {position += strlen(yytext); return Moins;}
\+       { position ++; return Plus;} 
{fleche} {position += strlen(yytext); return Fleche;}
{spc}  {position += strlen(yytext); return Spc;}
\^     {position ++; return Haut;}
_s|s   {position += strlen(yytext); return Sol;}
_g|g   {position += strlen(yytext); return Gas;}
_ag|aq {position += strlen(yytext); return Aqueous;}
=      {position ++; return Egal;}
{eol}  {/* rien c'est la fin des entres */}
.|\n   {position += strlen(yytext); /* rien */}
