/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

	/* This file contains a routine to do housekeeping:
	 * it erases obsolete session directories. 
	 * Policy: call cleaning() at each request to wims
	 * or each new/renew request? */

	/* Also can be called by cron. External names required:
	 * MAX_LINELEN, session_dir, idle_time, internal_error().
	 * Usage: wims cleansessions <idle_time>.
	 * Must be called at working directory. */

	/* internal */
void _cleaning(char *di)
{
    DIR *sdir_base;
    FILE *lastclean;
    struct dirent *ses;
    struct stat session_stat, lastclean_stat;
    char session_name[MAX_LINELEN+1], lastclean_name[1024];

    sdir_base=opendir(di);
    if(sdir_base==NULL)  {
	internal_warn("cleaning(): unable to open session directory.");
	return;
    }
    	/* when is last clean? */
    snprintf(lastclean_name, sizeof(lastclean_name),"%s/lastclean",di);
    if(stat(lastclean_name,&lastclean_stat)==0 &&
       lastclean_stat.st_atime>nowtime-700) return;
    while((ses=readdir(sdir_base))!=NULL) {
	if(strcmp(".",ses->d_name)==0 || strcmp("..",ses->d_name)==0) continue;
	snprintf(session_name,sizeof(session_name),"%s/%s",
		 di,ses->d_name);
	if(lstat(session_name,&session_stat)) {
	    /* internal_warn("cleaning(): session stat failure."); */
	    return;
	}
	if(!S_ISDIR(session_stat.st_mode)) { /* not a directory: remove it. */
	    if(remove(session_name)<0) {
		internal_warn("cleaning(): unable to chase squatter file in session directory. ");
		return;
	    }
	}
	    /* remove idle session. */
	else if(session_stat.st_atime<nowtime-idle_time) {
/* error if remove_tree returns non-zero. Warning or error? */	    
	    remove_tree(session_name);
	}
    }
    closedir(sdir_base);
    	/* touch lastclean file */
    lastclean=fopen(lastclean_name,"w"); fclose(lastclean);
}

	/* Clean obsolete session directories. */
void cleaning(void)
{
    	/* Active only if idle_time>0 */
    if(idle_time<=0) return;
    _cleaning(session_dir);
    _cleaning("../tmp/sessions");
}

void cleantmpdir(void)
{
    char buf[MAX_LINELEN+1], *p1, *p2;
    accessfile(buf,"r","%s/exec.pid",tmp_dir);
    for(p1=find_word_start(buf); *p1; p1=find_word_start(p2)) {
	p2=find_word_end(p1); if(*p2) *p2++=0;
	kill(atoi(p1),SIGKILL);
    }
    if(strstr(tmp_dir,"sessions/")!=NULL && (*tmp_debug==0 || checkhost(manager_site)<1))
      remove_tree(tmp_dir);
    else {
	snprintf(buf,sizeof(buf),"%s/exec.pid",tmp_dir);
	unlink(buf);
    }
}

	/* remove pid tag */
void delete_pid(void)
{
    char buf[256],pbuf[256];
    int i;
    FILE *f;

    if(robot_access || *session_prefix==0) return;
    cleantmpdir();
    snprintf(buf,sizeof(buf),"%s/.pid",session_prefix);
    f=fopen(buf,"r"); if(f==NULL) return;
    i=fread(pbuf,1,sizeof(pbuf)-1,f); fclose(f);
    if(i>=0 && i<sizeof(pbuf)) {
	pbuf[i]=pidbuf[sizeof(pidbuf)-1]=0;
	if(strcmp(pbuf,pidbuf)==0) unlink(buf);
    }
}

