/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

	/* This should be a rather independent routine, which are 
	 * used to interface an outside mathematical encyclopedia. */

void exec_href(char *p);

	/* Eric's Treasure Trove style */
/*void pedia_eric(char *p)
{
    char buf[MAX_LINELEN+1], *p1, *p2;
    int i;
    buf[0]=0;
    for(i=0;i<strlen(p);i++) if(p[i]=='_') p[i]=' ';
    for(p1=find_word_start(p);*p1!=0;p1=find_word_start(p2)){
	p2=find_word_end(p1);
	if(*p2!=0) *p2++=0;
	*p1=toupper(*p1);
	strcat(buf,p1);
    }
    if(buf[0]==0) strcpy(buf,"math0");
    strcpy(p,buf);
}
*/
	/* internal encyclopedia version */
void pedia_wims(char *p)
{
    char *s, *c, *t, buf[MAX_LINELEN+1];
    char r[MAX_LINELEN+1];

    t="target=wims_ref"; c="module=adm/enc.$module_language";
    s=getvar(ro_name[ro_module]);
    if(s!=NULL && strncmp(s,"adm/enc.",strlen("adm/enc."))==0) {
	c="cmd=reply"; t="";
    }
    else {
	s=getvar(ro_name[ro_session]);
	if(s!=NULL && strstr(s,"_dico")!=NULL) t="";
    }
    setvar("wims_dico_lookup",p);
    snprintf(buf,MAX_LINELEN,"%s %s&job=search&dom=math&search=$wims_dico_lookup %s",
	     t, c, p);
    snprintf(r,MAX_LINELEN,"%s",ref_name);
    if(pedia_address!=NULL && *pedia_address!=0) {
	snprintf(ref_name,MAX_LINELEN,"%s",pedia_address);
    }
    exec_href(buf);
    snprintf(ref_name,MAX_LINELEN,"%s",r);
}

	/* this is the (only) public routine in this file. */
void pedia(char *p)
{
    char *pp, *header, /* *ext,*/ *pt;
/*    char buf[MAX_LINELEN+1], buf2[MAX_LINELEN+1]; */
    int ptype;
    
    /* p points to first field (English name to search for).
     * pp points to second field (to show up).
     * If there is no field separator: by default. */
    pp=strchr(p,','); if(pp==NULL) pp=p;
    else *pp++=0;
    header=pedia_address; while(isspace(*header)) header++;
    pt=getvar("wims_pedia_type"); 
    if(pt!=NULL && *pt!=0) ptype=atoi(pt); else ptype=pedia_type;
    switch(ptype) {
	case 0: /* Eric's Treasure Trove */
/*	if(*header==0) {
	    strcpy(p,pp); return;
	}
	ext="html"; strcpy(buf,p);
	pedia_eric(buf);
	strcpy(buf2,pp);
	snprintf(p,MAX_LINELEN,"<A HREF=\"%s%s.%s\" target=wims_pedia>%s</A>",
		 pedia_address,buf,ext,buf2);
	break;
*/	
	case 1: /* internal encyclopedia */
	pedia_wims(pp); *p=0; return;

	default: 
	strcpy(p,pp); return;
    }
}

