/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* WWW mathematics server, header definitions */

#include "config.h"
#include "includes.h"
#include "wimsdef.h"

/*
#ifdef MACOSX
 #define CASE_INSENSITIVE_FS 1
#endif
*/
 
        /* limit of query_string. */
#define QUERY_STRING_LIMIT 204799
	/* maximal length of deposited file */
#define MAX_DEPOSITLEN (3*1024*1024)
	/* maximal number of registered variables */
#define MAX_VAR_NUM 512
	/* length limit for public_html/bin executable names */
#define MAX_EXEC_NAME 31
	/* max level of nested fors */
#define MAX_FOR_LEVEL 32
	/* max languages on a site, hard limit */
#define MAX_LANGUAGES 20
	/* max sort items. */
#define MAX_SORT_ITEM 5000
  /* Limit of output length. This can be configured. */
#define OUTPUT_LENGTH_LIMIT 400000
  /* limit of items in value lists */
#define MAX_VALUE_LIST 2048
	/* file to hold last output */
#define lastout	"last.html"

	/* Prefix char for exec functions */
#define exec_prefix_char '!'
	/* Prefix char for calc functions */
#define calc_prefix_char '!'
	/* Prefix char for goto labels */
#define label_prefix_char ':'
	/* Prefix for tags in data files */
#define tag_prefix_char ':'
	/* Tag string for randfile */
#define tag_string "\n:"
	/* Prefix char for comment lines */
#define comment_prefix_char '#'
  /* prefix to user variable names */
#define var_prefix	"w_"
  /* (user) prefix for mathematical fonts */
#define mathfont_prefix	"m_"
	/* Not configured */
#define error_data_string "wims_error_data"
  /* Name of files containing error messages. */
#define user_error_msg_file "msg/user_error.phtml"
#define module_error_msg_file "msg/module_error.msg"
  /* directory containing log files */
#define log_dir "../log"
  /* What should indicate that a file name given by the user 
   * would allow him to go upstairs in the directory tree?
   * We shouldn't use "../", otherwise the user may just specify
   * ".." as name and go upstairs one step. */
#define parent_dir_string ".."

typedef struct {
    int lineno; /* line number */
/*    long fpt;	*/ /* position in the file */
    char varname[MAX_NAMELEN+1];
    double varval;
    double varend;
    char *list_pt, *bufpt;
    double step;
    int from;	/* from ... to ... if 0, list if 1 */
} FOR_STACK;

typedef struct {
    char *address;
    short int execcode, varcode;
    int isstart; /* bit 0: start line; bit 1: exec; bit 2: label. */
    unsigned int llen;
} LINE_STRUCT;

typedef struct {
    char name[128];
    FILE *ff;
    int  l;
    int linepointer;
    int for_idx;
    int linecnt;
    char *textbuf;
    LINE_STRUCT *lines;
    FOR_STACK for_stack[MAX_FOR_LEVEL];
} WORKING_FILE;

struct {
    char *name;
    char *font;
} charname[]={
    {"en","iso-8859-1"},
      {"fr","iso-8859-1"},
      {"es","iso-8859-1"},
      {"cn","gb2312"},
      {"de","iso-8859-1"},
      {"it","iso-8859-1"},
      {"tw","big5"}
};

#define charname_no (sizeof(charname)/sizeof(charname[0]))

	/* var.c */
char *getvar(char *name);
int setvar(char *vname, char *vval);
void debug_output(void);

	/* variables.c */
void var_proc(char *fname);
void phtml_put(char *fname);
void phtml_put_base(char *fname);

	/* evalue.c */
double evalue(char *p);

	/* log.c */
void write_logs(void);

	/* insmmath.c */
void insmath(char *p);

	/* mathfonts.c */
void fix_tex_size(void);

	/* exam.c */
void calc_examdep(char *p);
