/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.MathObject;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SymbolTable;
import java.io.Serializable;

public class ParserContext
implements Serializable {
    public static final int END_OF_STRING = 1;
    public static final int NUMBER = 2;
    public static final int IDENTIFIER = 3;
    public static final int OPCHARS = 4;
    private static final int NONE = 0;
    public String data;
    public int pos;
    public ExpressionProgram prog;
    public int token;
    public String tokenString;
    public MathObject tokenObject;
    public double tokenValue;
    public int options;
    protected SymbolTable symbols;
    private StringBuffer tokBuf = new StringBuffer();

    public ParserContext(String string, int n, SymbolTable symbolTable) {
        this.data = string;
        this.options = n;
        this.symbols = symbolTable;
        this.prog = new ExpressionProgram();
    }

    public void mark() {
        this.symbols = new SymbolTable(this.symbols);
    }

    public void revert() {
        this.symbols = this.symbols.getParent();
    }

    public MathObject get(String string) {
        if ((this.options & 1) != 0) {
            return this.symbols.get(string);
        }
        return this.symbols.get(string.toLowerCase());
    }

    public void add(MathObject mathObject) {
        if ((this.options & 1) != 0) {
            this.symbols.add(mathObject);
        } else {
            this.symbols.add(mathObject.getName().toLowerCase(), mathObject);
        }
    }

    public int next() {
        int n = this.look();
        if (this.token != 1) {
            this.token = 0;
        }
        return n;
    }

    public int look() {
        if (this.token == 0) {
            while (this.pos < this.data.length() && (this.data.charAt(this.pos) == ' ' || this.data.charAt(this.pos) == '\t')) {
                ++this.pos;
            }
            if (this.pos >= this.data.length()) {
                this.token = 1;
                this.tokenString = null;
            } else {
                this.readToken();
            }
        }
        return this.token;
    }

    /*
     * Unable to fully structure code
     */
    private void readToken() {
        block27: {
            block29: {
                block30: {
                    block28: {
                        var1_1 = this.data.charAt(this.pos);
                        var2_2 = this.pos;
                        this.tokBuf.setLength(0);
                        if (!Character.isLetter(var1_1) && (var1_1 != '_' || (this.options & 128) != 0)) break block28;
                        this.token = 3;
                        while (Character.isLetter(var1_1) || var1_1 == '_' && (this.options & 128) == 0 || Character.isDigit(var1_1) && (this.options & 256) == 0) {
                            this.tokBuf.append(var1_1);
                            ++this.pos;
                            if (this.pos >= this.data.length()) break;
                            var1_1 = this.data.charAt(this.pos);
                        }
                        this.tokenString = this.tokBuf.toString();
                        this.tokenObject = null;
                        var3_3 = this.tokenString.length();
                        while (var3_3 > 0) {
                            var4_6 = this.tokenString.substring(0, var3_3);
                            if ((this.options & 32) != 0) {
                                if (var4_6.equalsIgnoreCase("and")) {
                                    this.token = 4;
                                    this.tokenString = "&";
                                    this.pos = var2_2 + 3;
                                    return;
                                }
                                if (var4_6.equalsIgnoreCase("or")) {
                                    this.token = 4;
                                    this.tokenString = "|";
                                    this.pos = var2_2 + 2;
                                    return;
                                }
                                if (var4_6.equalsIgnoreCase("not")) {
                                    this.token = 4;
                                    this.tokenString = "~";
                                    this.pos = var2_2 + 3;
                                    return;
                                }
                            }
                            if (this.get(var4_6) != null) {
                                this.tokenString = var4_6;
                                this.tokenObject = this.get(this.tokenString);
                                this.pos = var2_2 + var3_3;
                            } else if ((this.options & 4) != 0) {
                                --var3_3;
                                continue;
                            }
                            break block27;
                        }
                        break block27;
                    }
                    if (!Character.isDigit(var1_1) && (var1_1 != '.' || this.pos >= this.data.length() - 1 || !Character.isDigit(this.data.charAt(this.pos + 1)))) break block29;
                    this.token = 2;
                    while (this.pos < this.data.length() && Character.isDigit(this.data.charAt(this.pos))) {
                        this.tokBuf.append(this.data.charAt(this.pos++));
                    }
                    if (this.pos < this.data.length() && this.data.charAt(this.pos) == '.') {
                        this.tokBuf.append(this.data.charAt(this.pos++));
                        while (this.pos < this.data.length() && Character.isDigit(this.data.charAt(this.pos))) {
                            this.tokBuf.append(this.data.charAt(this.pos++));
                        }
                    }
                    if (this.pos >= this.data.length() || this.data.charAt(this.pos) != 'e' && this.data.charAt(this.pos) != 'E') break block30;
                    var2_2 = this.pos;
                    this.tokBuf.append(this.data.charAt(this.pos++));
                    if (this.pos < this.data.length() && (this.data.charAt(this.pos) == '+' || this.data.charAt(this.pos) == '-')) {
                        this.tokBuf.append(this.data.charAt(this.pos++));
                    }
                    if (this.pos < this.data.length() && Character.isDigit(this.data.charAt(this.pos))) ** GOTO lbl72
                    if ((this.options & 2) == 0) {
                        throw new ParseError("Illegal number, '" + this.tokBuf.toString() + "'.  No digits in exponential part.", this);
                    }
                    this.pos = var2_2;
                    break block30;
lbl-1000:
                    // 1 sources

                    {
                        this.tokBuf.append(this.data.charAt(this.pos++));
lbl72:
                        // 2 sources

                        ** while (this.pos < this.data.length() && Character.isDigit((char)this.data.charAt((int)this.pos)))
                    }
                }
                this.tokenString = this.tokBuf.toString();
                var3_4 = NumUtils.stringToReal(this.tokenString);
                if (Double.isInfinite(var3_4)) {
                    throw new ParseError("The number '" + this.tokBuf.toString() + "' is outside the range of legal numbers.", this);
                }
                if (Double.isNaN(var3_4)) {
                    throw new ParseError("The string '" + this.tokBuf.toString() + "' is not a legal number.", this);
                }
                this.tokenValue = var3_4;
                break block27;
            }
            this.token = 4;
            this.tokenString = String.valueOf(var1_1);
            ++this.pos;
            if (this.pos < this.data.length()) {
                var3_5 = this.data.charAt(this.pos);
                switch (var1_1) {
                    case '*': {
                        if (var3_5 != '*') break;
                        this.tokenString = "^";
                        ++this.pos;
                        break;
                    }
                    case '=': {
                        if (var3_5 == '<' || var3_5 == '>') {
                            this.tokenString = String.valueOf(this.data.charAt(this.pos++)) + this.tokenString;
                        }
                        break;
                    }
                    case '<': {
                        if (var3_5 == '=' || var3_5 == '>') {
                            this.tokenString = String.valueOf(this.tokenString) + this.data.charAt(this.pos++);
                        }
                        break;
                    }
                    case '>': {
                        if (var3_5 == '=') {
                            this.tokenString = String.valueOf(this.tokenString) + this.data.charAt(this.pos++);
                            break;
                        }
                        if (var3_5 != '<') break;
                        this.tokenString = String.valueOf(this.data.charAt(this.pos++)) + this.tokenString;
                        break;
                    }
                }
            }
        }
    }
}

