/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedInputStream;

public class EMFInputStream
extends TaggedInputStream
implements EMFConstants {
    public static int DEFAULT_VERSION = 1;
    private EMFHeader header;

    public EMFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, DEFAULT_VERSION);
    }

    public EMFInputStream(InputStream inputStream, int n2) throws IOException {
        this(inputStream, new EMFTagSet(n2));
    }

    public EMFInputStream(InputStream inputStream, EMFTagSet eMFTagSet) throws IOException {
        super(inputStream, eMFTagSet, null, true);
    }

    public int readDWORD() throws IOException {
        long l2 = this.readUnsignedInt();
        return (int)l2;
    }

    public int[] readDWORD(int n2) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.readDWORD();
        }
        return nArray;
    }

    public int readWORD() throws IOException {
        return this.readUnsignedShort();
    }

    public int readLONG() throws IOException {
        return this.readInt();
    }

    public int[] readLONG(int n2) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.readLONG();
        }
        return nArray;
    }

    public float readFLOAT() throws IOException {
        return this.readFloat();
    }

    public int readUINT() throws IOException {
        return (int)this.readUnsignedInt();
    }

    public int readULONG() throws IOException {
        return (int)this.readUnsignedInt();
    }

    public Color readCOLORREF() throws IOException {
        Color color = new Color(this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte());
        this.readByte();
        return color;
    }

    public Color readCOLOR16() throws IOException {
        return new Color(this.readShort() >> 8, this.readShort() >> 8, this.readShort() >> 8, this.readShort() >> 8);
    }

    public AffineTransform readXFORM() throws IOException {
        return new AffineTransform(this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT(), this.readFLOAT());
    }

    public Rectangle readRECTL() throws IOException {
        int n2 = this.readLONG();
        int n3 = this.readLONG();
        int n4 = this.readLONG() - n2;
        int n5 = this.readLONG() - n3;
        return new Rectangle(n2, n3, n4, n5);
    }

    public Point readPOINTL() throws IOException {
        int n2 = this.readLONG();
        int n3 = this.readLONG();
        return new Point(n2, n3);
    }

    public Point[] readPOINTL(int n2) throws IOException {
        Point[] pointArray = new Point[n2];
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            pointArray[i2] = this.readPOINTL();
        }
        return pointArray;
    }

    public Point readPOINTS() throws IOException {
        short s2 = this.readShort();
        short s3 = this.readShort();
        return new Point(s2, s3);
    }

    public Point[] readPOINTS(int n2) throws IOException {
        Point[] pointArray = new Point[n2];
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            pointArray[i2] = this.readPOINTS();
        }
        return pointArray;
    }

    public Dimension readSIZEL() throws IOException {
        return new Dimension(this.readLONG(), this.readLONG());
    }

    public int readBYTE() throws IOException {
        return this.readByte();
    }

    public byte[] readBYTE(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)this.readBYTE();
        }
        return byArray;
    }

    public boolean readBOOLEAN() throws IOException {
        return this.readBYTE() != 0;
    }

    public String readWCHAR(int n2) throws IOException {
        byte[] byArray = this.readByte(2 * n2);
        int n3 = 2 * n2;
        for (int i2 = 0; i2 < 2 * n2; i2 += 2) {
            if (byArray[i2] != 0 || byArray[i2 + 1] != 0) continue;
            n3 = i2;
            break;
        }
        return new String(byArray, 0, n3, "UTF-16LE");
    }

    protected TagHeader readTagHeader() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            return null;
        }
        n2 |= this.readUnsignedByte() << 8;
        n2 |= this.readUnsignedByte() << 16;
        long l2 = this.readDWORD();
        return new TagHeader(n2 |= this.readUnsignedByte() << 24, l2 - 8L);
    }

    protected ActionHeader readActionHeader() throws IOException {
        return null;
    }

    public EMFHeader readHeader() throws IOException {
        if (this.header == null) {
            this.header = new EMFHeader(this);
        }
        return this.header;
    }

    public int getVersion() {
        return DEFAULT_VERSION;
    }
}

