/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolygon
extends EMFTag {
    private Rectangle bounds;
    private int start;
    private int end;
    private int[] numberOfPoints;
    private Point[][] points;

    public PolyPolygon() {
        super(8, 1);
    }

    public PolyPolygon(Rectangle rectangle, int n2, int n3, int[] nArray, Point[][] pointArray) {
        this();
        this.bounds = rectangle;
        this.start = n2;
        this.end = n3;
        this.numberOfPoints = nArray;
        this.points = pointArray;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        int n4;
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n5 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int[] nArray = new int[n5];
        Point[][] pointArray = new Point[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = eMFInputStream.readDWORD();
            pointArray[n4] = new Point[nArray[n4]];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            pointArray[n4] = eMFInputStream.readPOINTL(nArray[n4]);
        }
        PolyPolygon polyPolygon = new PolyPolygon(rectangle, 0, n5 - 1, nArray, pointArray);
        return polyPolygon;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        int n3;
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeDWORD(this.end - this.start + 1);
        int n4 = 0;
        for (n3 = this.start; n3 < this.end + 1; ++n3) {
            n4 += this.numberOfPoints[n3];
        }
        eMFOutputStream.writeDWORD(n4);
        for (n3 = this.start; n3 < this.end + 1; ++n3) {
            eMFOutputStream.writeDWORD(this.numberOfPoints[n3]);
        }
        for (n3 = this.start; n3 < this.end + 1; ++n3) {
            eMFOutputStream.writePOINTL(this.numberOfPoints[n3], this.points[n3]);
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + (this.end - this.start + 1);
    }
}

