/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class TextW
implements EMFConstants {
    private Point pos;
    private String string;
    private int options;
    private int[] widths;
    private Rectangle bounds;

    public TextW(Point point, String string, int n2, Rectangle rectangle, int[] nArray) {
        this.pos = point;
        this.string = string;
        this.options = n2;
        this.bounds = rectangle;
        this.widths = nArray;
    }

    public TextW(EMFInputStream eMFInputStream) throws IOException {
        int n2;
        this.pos = eMFInputStream.readPOINTL();
        int n3 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        this.options = eMFInputStream.readDWORD();
        this.bounds = eMFInputStream.readRECTL();
        eMFInputStream.readDWORD();
        this.string = new String(eMFInputStream.readBYTE(2 * n3), "UTF-16LE");
        if (2 * n3 % 4 != 0) {
            for (n2 = 0; n2 < 4 - 2 * n3 % 4; ++n2) {
                eMFInputStream.readBYTE();
            }
        }
        this.widths = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.widths[n2] = eMFInputStream.readDWORD();
        }
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        int n2;
        eMFOutputStream.writePOINTL(this.pos);
        eMFOutputStream.writeDWORD(this.string.length());
        eMFOutputStream.writeDWORD(76);
        eMFOutputStream.writeDWORD(this.options);
        eMFOutputStream.writeRECTL(this.bounds);
        int n3 = 2 * this.string.length() % 4;
        if (n3 > 0) {
            n3 = 4 - n3;
        }
        eMFOutputStream.writeDWORD(76 + 2 * this.string.length() + n3);
        eMFOutputStream.writeBYTE(this.string.getBytes("UTF-16LE"));
        for (n2 = 0; n2 < n3; ++n2) {
            eMFOutputStream.writeBYTE(0);
        }
        for (n2 = 0; n2 < this.string.length(); ++n2) {
            eMFOutputStream.writeDWORD(this.widths[n2]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.string.length(); ++i2) {
            stringBuffer.append("," + this.widths[i2]);
        }
        stringBuffer.append(']');
        stringBuffer.setCharAt(0, '[');
        return "  Text\n    pos: " + this.pos + "\n" + "    options: " + this.options + "\n" + "    bounds: " + this.bounds + "\n" + "    string: " + this.string + "\n" + "    widths: " + stringBuffer;
    }
}

