/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class HinReader
extends AtomSetCollectionReader {
    int atomIndex;
    int baseAtomIndex;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("hin");
        try {
            this.readAtoms();
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        while (this.readLine() != null) {
            if (this.line.length() == 0 || this.line.charAt(0) == ';') continue;
            if (this.line.startsWith("mol ")) {
                this.processMol();
                continue;
            }
            if (this.line.startsWith("atom ")) {
                this.processAtom();
                continue;
            }
            if (!this.line.startsWith("endmol ")) continue;
            this.processEndmol();
        }
    }

    void processMol() throws Exception {
        this.atomSetCollection.newAtomSet();
        String string = this.getMolName();
        this.atomSetCollection.setAtomSetName(string);
        this.atomIndex = 0;
        this.baseAtomIndex = this.atomSetCollection.getAtomCount();
    }

    String getMolName() {
        this.parseToken(this.line);
        this.parseToken();
        return this.parseToken();
    }

    void processAtom() throws Exception {
        int n = this.parseInt(this.line, 5);
        if (n - 1 != this.atomIndex) {
            throw new Exception("bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + n);
        }
        Atom atom = this.atomSetCollection.addNewAtom();
        this.parseToken();
        atom.elementSymbol = this.parseToken();
        this.parseToken();
        this.parseToken();
        atom.partialCharge = this.parseFloat();
        atom.x = this.parseFloat();
        atom.y = this.parseFloat();
        atom.z = this.parseFloat();
        int n2 = this.parseInt();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = this.parseInt();
            String string = this.parseToken();
            if (n4 > this.atomIndex) continue;
            switch (string.charAt(0)) {
                case 's': {
                    n3 = 1;
                    break;
                }
                case 'd': {
                    n3 = 2;
                    break;
                }
                case 't': {
                    n3 = 3;
                    break;
                }
                case 'a': {
                    n3 = 515;
                    break;
                }
                default: {
                    throw new Exception("unrecognized bond type:" + string + " atom #" + n);
                }
            }
            this.atomSetCollection.addNewBond(this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + n4 - 1, n3);
        }
        ++this.atomIndex;
    }

    void processEndmol() {
    }
}

