/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class QchemReader
extends AtomSetCollectionReader {
    private int calculationNumber = 1;
    Hashtable moData = null;
    String[] alphaLabels = null;
    String[] betaLabels = null;
    int nShell = 0;
    int nBasis = 0;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("qchem");
        try {
            int n = 0;
            while (this.readLine() != null) {
                if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
                    this.readAtoms();
                    this.moData = null;
                } else if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
                    this.readFrequencies();
                } else if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
                    this.readPartialCharges();
                } else if (this.line.indexOf("Job ") >= 0) {
                    ++this.calculationNumber;
                } else if (this.line.indexOf("Basis set in general basis input format") >= 0) {
                    this.readBasis();
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
                } else if (this.line.indexOf("Orbital Energies (a.u.) and Symmetries") >= 0) {
                    if (this.moData != null) {
                        this.readLabels();
                    }
                } else if (this.line.indexOf("Orbital Energies (a.u.)") >= 0) {
                    if (this.moData != null) {
                        this.readNoSymLabels();
                    }
                } else if (this.line.indexOf("MOLECULAR ORBITAL COEFFICIENTS") >= 0 && this.moData != null) {
                    this.readOrbitals();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.discardLines(2);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String string;
            String[] stringArray = this.getTokens();
            if (stringArray.length < 5 || JmolAdapter.getElementNumber(string = stringArray[1]) < 1) continue;
            float f = this.parseFloat(stringArray[2]);
            float f2 = this.parseFloat(stringArray[3]);
            float f3 = this.parseFloat(stringArray[4]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.set(f, f2, f3);
            this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber);
        }
    }

    private void readFrequencies() throws Exception, IOException {
        String[] stringArray = AtomSetCollectionReader.getTokens(this.discardLinesUntilStartsWith(" Frequency:"));
        while (true) {
            int n;
            int n2 = stringArray.length;
            for (n = 1; n < n2; ++n) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(stringArray[n] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", stringArray[n] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            n = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = this.atomSetCollection.getAtomCount() - n2 * n;
            this.discardLinesUntilStartsWith("               X");
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = AtomSetCollectionReader.getTokens(this.readLine());
                int n4 = 1;
                for (int j = 1; j < n2; ++j) {
                    int n5 = n3 + j * n + i;
                    Atom atom = atomArray[n5];
                    float f = this.parseFloat(stringArray2[n4++]);
                    float f2 = this.parseFloat(stringArray2[n4++]);
                    float f3 = this.parseFloat(stringArray2[n4++]);
                    atom.addVibrationVector(f, f2, f3);
                }
            }
            while ((this.line = this.readLine()) != null && this.line.length() > 0) {
            }
            this.line = this.readLine();
            if (this.line.indexOf("STANDARD") >= 0) break;
            if (this.line.indexOf(" Frequency:") == -1) {
                stringArray = AtomSetCollectionReader.getTokens(this.discardLinesUntilStartsWith(" Frequency:"));
                continue;
            }
            stringArray = AtomSetCollectionReader.getTokens(this.line);
        }
    }

    void readPartialCharges() throws Exception {
        this.discardLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomCount();
        for (int i = 0; i < n && this.readLine() != null; ++i) {
            atomArray[i].partialCharge = this.parseFloat(this.getTokens()[2]);
        }
    }

    private void readBasis() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        Object object;
        this.moData = new Hashtable();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector<float[][]> vector = new Vector<float[][]>();
        Vector<String[]> vector2 = new Vector<String[]>();
        this.discardLinesUntilStartsWith("$basis");
        this.readLine();
        while (this.readLine() != null) {
            if (this.line.startsWith("****")) {
                ++n3;
                if (this.readLine() == null || !this.line.startsWith("$end")) continue;
                break;
            }
            ++n4;
            object = new int[4];
            stringArray = AtomSetCollectionReader.getTokens(this.line);
            object[0] = (float[])n3;
            object[1] = (float[])JmolAdapter.getQuantumShellTagID(stringArray[0]);
            object[2] = (float[])n5;
            n2 = this.parseInt(stringArray[1]);
            object[3] = (float[])n2;
            vector.addElement((float[][])object);
            n5 += n2;
            for (n = 0; n < n2; ++n) {
                vector2.addElement(AtomSetCollectionReader.getTokens(this.readLine()));
            }
        }
        object = new float[n5][];
        for (n2 = 0; n2 < n5; ++n2) {
            stringArray = (String[])vector2.get(n2);
            object[n2] = new float[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object[n2][n] = this.parseFloat(stringArray[n]);
            }
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug(n4 + " slater shells read");
            Logger.debug(n5 + " gaussian primitives read");
        }
        this.discardLinesUntilStartsWith(" There are");
        stringArray = AtomSetCollectionReader.getTokens(this.line);
        this.nShell = this.parseInt(stringArray[2]);
        this.nBasis = this.parseInt(stringArray[5]);
    }

    protected void readLabels() throws Exception {
        String string = "???";
        String[] stringArray = new String[]{"A", "B"};
        this.alphaLabels = new String[this.nBasis];
        this.betaLabels = new String[this.nBasis];
        this.discardLinesUntilStartsWith(" Alpha");
        String string2 = AtomSetCollectionReader.getTokens(this.line)[2];
        String[] stringArray2 = this.alphaLabels;
        block0: for (int i = 0; i < 2; ++i) {
            int n = 0;
            while (this.readLine() != null) {
                if (this.line.startsWith(" -- ")) {
                    string = this.makeOccupancy(string2, stringArray[i], AtomSetCollectionReader.getTokens(this.line));
                    this.readLine();
                }
                if (this.line.startsWith(" -------")) continue block0;
                int n2 = AtomSetCollectionReader.getTokens(this.line).length;
                if (n2 == 0 || this.line.startsWith(" Warning")) {
                    this.discardLinesUntilStartsWith(" Beta");
                    stringArray2 = this.betaLabels;
                    continue block0;
                }
                String[] stringArray3 = AtomSetCollectionReader.getTokens(this.readLine());
                int n3 = 0;
                int n4 = 0;
                while (n3 < n2) {
                    stringArray2[n] = stringArray3[n4] + stringArray3[n4 + 1] + "--" + string;
                    ++n;
                    ++n3;
                    n4 += 2;
                }
            }
        }
    }

    protected void readNoSymLabels() throws Exception {
        String string = "???";
        this.alphaLabels = new String[this.nBasis];
        this.betaLabels = new String[this.nBasis];
        this.discardLinesUntilStartsWith(" Alpha");
        String[] stringArray = this.alphaLabels;
        block0: for (int i = 0; i < 2; ++i) {
            int n = 0;
            while (this.readLine() != null) {
                if (this.line.startsWith(" -- Occ")) {
                    string = "(O)";
                    this.readLine();
                } else if (this.line.startsWith(" -- Vir")) {
                    string = "(V)";
                    this.readLine();
                }
                if (this.line.startsWith(" -------")) {
                    i = 2;
                    continue block0;
                }
                int n2 = AtomSetCollectionReader.getTokens(this.line).length;
                if (n2 == 0 || this.line.startsWith(" Warning")) {
                    this.discardLinesUntilStartsWith(" Beta");
                    stringArray = this.betaLabels;
                    continue block0;
                }
                for (int j = 0; j < n2; ++j) {
                    stringArray[n] = "??? " + string;
                    ++n;
                }
            }
        }
    }

    private String makeOccupancy(String string, String string2, String[] stringArray) {
        String string3 = stringArray[1];
        string3 = string.equals("Unrestricted") ? (string3.equals("Occupied") ? string2 : "V" + string2) : (string3.equals("Occupied") || string3.equals("Doubly") ? "AB" : (string3.equals("Virtual") ? "V" : (stringArray[3].equals("(Occupied)") ? "RO-1" + string2 : "RO-0" + string2)));
        return string3;
    }

    private void readOrbitals() throws Exception {
        Object object;
        int n;
        int[] nArray = new int[]{1, 3, 4, 6, 5, 10, 7};
        int[][] nArrayArray = new int[][]{{0}, {0, 1, 2}, {0, 1, 2, 3}, {0, 3, 1, 4, 5, 2}, {4, 2, 0, 1, 3}, {0, 4, 3, 1, 5, 9, 8, 6, 7, 2}, {6, 4, 2, 0, 1, 3, 5}};
        float[] fArray = new float[10];
        Vector vector = new Vector();
        String[] stringArray = new String[this.nBasis];
        String string = AtomSetCollectionReader.getTokens(this.line)[0];
        int n2 = this.readMOs(stringArray, vector, this.alphaLabels);
        if (string.equals("ALPHA")) {
            this.discardLinesUntilContains("BETA");
            n2 += this.readMOs(stringArray, vector, this.betaLabels);
        }
        int n3 = 0;
        Vector vector2 = (Vector)this.moData.get("shells");
        float[][] fArrayArray = new float[n2][];
        for (n = 0; n < n2; ++n) {
            object = (Hashtable)vector.get(n);
            fArrayArray[n] = (float[])((Hashtable)object).get("coefficients");
        }
        for (n = 0; n < this.nShell; ++n) {
            object = (int[])vector2.get(n);
            if (AtomSetCollectionReader.getTokens(stringArray[n3]).length > 1) {
                Object object2 = object;
                object2[1] = object2[1] + true;
            }
            int n4 = nArray[object[1]];
            if (object[1] >= 3) {
                for (int i = 0; i < n2; ++i) {
                    int[] nArray2 = nArrayArray[object[1]];
                    int n5 = 0;
                    int n6 = n3;
                    while (n5 < n4) {
                        fArray[nArray2[n5]] = fArrayArray[i][n6];
                        ++n5;
                        ++n6;
                    }
                    n5 = 0;
                    n6 = n3;
                    while (n5 < n4) {
                        fArrayArray[i][n6] = fArray[n5];
                        ++n5;
                        ++n6;
                    }
                }
            }
            n3 += n4;
        }
        this.moData.put("mos", vector);
        this.moData.put("energyUnits", "au");
        this.setMOData(this.moData);
    }

    private int readMOs(String[] stringArray, Vector vector, String[] stringArray2) throws Exception {
        Hashtable[] hashtableArray = new Hashtable[6];
        float[][] fArrayArray = new float[6][];
        int[] nArray = new int[6];
        int n = 0;
        while (this.readLine().length() > 2) {
            int n2;
            String[] stringArray3 = AtomSetCollectionReader.getTokens(this.line);
            int n3 = stringArray3.length;
            String[] stringArray4 = AtomSetCollectionReader.getTokens(this.readLine().substring(13));
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.parseInt(stringArray3[n2]) - 1;
                fArrayArray[n2] = new float[this.nBasis];
                hashtableArray[n2] = new Hashtable();
            }
            for (n2 = 0; n2 < this.nBasis; ++n2) {
                stringArray3 = AtomSetCollectionReader.getTokens(this.readLine());
                stringArray[n2] = this.line.substring(12, 17);
                int n4 = stringArray3.length - n3;
                for (int i = 0; i < n3; ++i) {
                    fArrayArray[i][n2] = this.parseFloat(stringArray3[n4]);
                    ++n4;
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                hashtableArray[n2].put("energy", new Float(stringArray4[n2]));
                hashtableArray[n2].put("coefficients", fArrayArray[n2]);
                hashtableArray[n2].put("symmetry", stringArray2[nArray[n2]] + "(" + (nArray[n2] + 1) + ")");
                vector.addElement(hashtableArray[n2]);
            }
            n += n3;
        }
        return n;
    }
}

